/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.utils.IpAddressMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IpAddressMatcherTest {
    IpAddressMatcherTest() {
    }

    @Test
    void testIpRangeMatcher() {
        Assertions.assertTrue((boolean)new IpAddressMatcher("192.168.10.110").matches("192.168.10.110"));
        Assertions.assertTrue((boolean)new IpAddressMatcher("192.168.1.0/8").matches("192.168.10.110"));
        Assertions.assertTrue((boolean)new IpAddressMatcher("192.168.1.0/24").matches("192.168.1.100"));
        Assertions.assertFalse((boolean)new IpAddressMatcher("192.168.1.0/24").matches("193.168.1.10"));
        Assertions.assertFalse((boolean)new IpAddressMatcher("192.168.1.0/24").matches("192.168.2.10"));
        Assertions.assertFalse((boolean)new IpAddressMatcher("192.168.1.0/24").matches("192.168.2.10"));
        Assertions.assertFalse((boolean)new IpAddressMatcher("192.168.1.0/8").matches("193.168.1.10"));
        Assertions.assertFalse((boolean)new IpAddressMatcher("no.proxy").matches("kubernetes.default.svc"));
    }

    @Test
    void testIpAddressRegexp() {
        try {
            Pattern pattern = Pattern.compile("(http:\\/\\/|https:\\/\\/)?(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])(\\/[0-9]\\d|1[0-9]\\d|2[0-9]\\d|3[0-2]\\d)?", 2);
            Matcher matcherPlain = pattern.matcher("192.168.0.1");
            Assertions.assertTrue((boolean)matcherPlain.matches());
            Matcher matcherPlainProtocol = pattern.matcher("http://192.168.0.1");
            Assertions.assertTrue((boolean)matcherPlainProtocol.matches());
            Matcher matcherPlainProtocol2 = pattern.matcher("https://192.168.0.1");
            Assertions.assertTrue((boolean)matcherPlainProtocol2.matches());
            Matcher matcherRange = pattern.matcher("192.168.0.1/24");
            Assertions.assertTrue((boolean)matcherRange.matches());
            Matcher matcherRangeProtocol = pattern.matcher("http://192.168.0.1/24");
            Assertions.assertTrue((boolean)matcherRangeProtocol.matches());
            Matcher matcherRangeProtocol2 = pattern.matcher("https://192.168.0.1/24");
            Assertions.assertTrue((boolean)matcherRangeProtocol2.matches());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to compile pattern.");
        }
    }
}

