/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientProxyTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="Proxied HttpClient adds required headers to the request")
    void proxyConfigurationAddsRequiredHeaders() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().proxyAddress(new InetSocketAddress("localhost", server.getPort())).proxyAuthorization("auth:cred");
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(String.format("http://0.0.0.0:%s/not-found", server.getPort())).build(), String.class).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)server.getLastRequest()).extracting(RecordedRequest::getHeaders).extracting(Headers::toMultimap).hasFieldOrPropertyWithValue("Host", Collections.singletonList("0.0.0.0:" + server.getPort())).hasFieldOrPropertyWithValue("Proxy-Authorization", Collections.singletonList("auth:cred"));
        }
    }
}

