package io.fabric8.kubernetes.client;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RequestConfigFluentImpl<A extends RequestConfigFluent<A>> extends BaseFluent<A> implements RequestConfigFluent<A>{
  public RequestConfigFluentImpl() {
  }
  public RequestConfigFluentImpl(io.fabric8.kubernetes.client.RequestConfig instance) {
    this.withUsername(instance.getUsername()); 
    this.withPassword(instance.getPassword()); 
    this.withOauthToken(instance.getOauthToken()); 
    this.withWatchReconnectLimit(instance.getWatchReconnectLimit()); 
    this.withWatchReconnectInterval(instance.getWatchReconnectInterval()); 
    this.withConnectionTimeout(instance.getConnectionTimeout()); 
    this.withRollingTimeout(instance.getRollingTimeout()); 
    this.withRequestTimeout(instance.getRequestTimeout()); 
    this.withScaleTimeout(instance.getScaleTimeout()); 
    this.withLoggingInterval(instance.getLoggingInterval()); 
    this.withWebsocketTimeout(instance.getWebsocketTimeout()); 
    this.withWebsocketPingInterval(instance.getWebsocketPingInterval()); 
    this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests()); 
    this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost()); 
    this.withOauthTokenProvider(instance.getOauthTokenProvider()); 
    this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit()); 
    this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval()); 
    this.withUploadConnectionTimeout(instance.getUploadConnectionTimeout()); 
    this.withUploadRequestTimeout(instance.getUploadRequestTimeout()); 
    this.withImpersonateUsername(instance.getImpersonateUsername());

    this.withImpersonateGroups(instance.getImpersonateGroups());

    this.withImpersonateExtras(instance.getImpersonateExtras());

  }
  private String username;
  private java.lang.String password;
  private java.lang.String oauthToken;
  private OAuthTokenProvider oauthTokenProvider;
  private java.lang.String impersonateUsername;
  private List<java.lang.String> impersonateGroups;
  private Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras;
  private int watchReconnectInterval;
  private int watchReconnectLimit;
  private int connectionTimeout;
  private int uploadConnectionTimeout;
  private int uploadRequestTimeout;
  private int requestRetryBackoffLimit;
  private int requestRetryBackoffInterval;
  private int requestTimeout;
  private long rollingTimeout;
  private long scaleTimeout;
  private int loggingInterval;
  private long websocketTimeout;
  private long websocketPingInterval;
  private int maxConcurrentRequests;
  private int maxConcurrentRequestsPerHost;
  public java.lang.String getUsername() {
    return this.username;
  }
  public A withUsername(java.lang.String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public java.lang.String getPassword() {
    return this.password;
  }
  public A withPassword(java.lang.String password) {
    this.password=password; return (A) this;
  }
  public java.lang.Boolean hasPassword() {
    return this.password != null;
  }
  public java.lang.String getOauthToken() {
    return this.oauthToken;
  }
  public A withOauthToken(java.lang.String oauthToken) {
    this.oauthToken=oauthToken; return (A) this;
  }
  public java.lang.Boolean hasOauthToken() {
    return this.oauthToken != null;
  }
  public io.fabric8.kubernetes.client.OAuthTokenProvider getOauthTokenProvider() {
    return this.oauthTokenProvider;
  }
  public A withOauthTokenProvider(io.fabric8.kubernetes.client.OAuthTokenProvider oauthTokenProvider) {
    this.oauthTokenProvider=oauthTokenProvider; return (A) this;
  }
  public java.lang.Boolean hasOauthTokenProvider() {
    return this.oauthTokenProvider != null;
  }
  public java.lang.String getImpersonateUsername() {
    return this.impersonateUsername;
  }
  public A withImpersonateUsername(java.lang.String impersonateUsername) {
    this.impersonateUsername=impersonateUsername; return (A) this;
  }
  public java.lang.Boolean hasImpersonateUsername() {
    return this.impersonateUsername != null;
  }
  public A withImpersonateGroups(java.lang.String... impersonateGroups) {
    if (this.impersonateGroups != null) {this.impersonateGroups.clear();}
    if (impersonateGroups != null) {for (java.lang.String item :impersonateGroups){ this.addToImpersonateGroups(item);}} return (A) this;
  }
  public java.lang.String[] getImpersonateGroups() {
    //This needs to work with primitives, so we use arrays.
int size = impersonateGroups != null ? impersonateGroups.size() : 0;
java.lang.String[] result = new java.lang.String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (java.lang.String item : impersonateGroups) {
    result[index++]=item;
}
return result;

  }
  public A addToImpersonateGroups(Integer index,java.lang.String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<java.lang.String>();}
    this.impersonateGroups.add(index, item);
    return (A)this;
  }
  public A setToImpersonateGroups(java.lang.Integer index,java.lang.String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
    this.impersonateGroups.set(index, item); return (A)this;
  }
  public A addToImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A addAllToImpersonateGroups(Collection<java.lang.String> items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A removeFromImpersonateGroups(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromImpersonateGroups(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
  }
  public java.lang.Boolean hasImpersonateGroups() {
    return impersonateGroups != null && !impersonateGroups.isEmpty();
  }
  public A addToImpersonateExtras(java.lang.String key,java.util.List<java.lang.String> value) {
    if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
  }
  public A addToImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map) {
    if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new java.util.LinkedHashMap(); }
    if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
  }
  public A removeFromImpersonateExtras(java.lang.String key) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
  }
  public A removeFromImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getImpersonateExtras() {
    return this.impersonateExtras;
  }
  public <K,V>A withImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras) {
    if (impersonateExtras == null) { this.impersonateExtras =  null;} else {this.impersonateExtras = new java.util.LinkedHashMap(impersonateExtras);} return (A) this;
  }
  public java.lang.Boolean hasImpersonateExtras() {
    return this.impersonateExtras != null;
  }
  public int getWatchReconnectInterval() {
    return this.watchReconnectInterval;
  }
  public A withWatchReconnectInterval(int watchReconnectInterval) {
    this.watchReconnectInterval=watchReconnectInterval; return (A) this;
  }
  public java.lang.Boolean hasWatchReconnectInterval() {
    return true;
  }
  public int getWatchReconnectLimit() {
    return this.watchReconnectLimit;
  }
  public A withWatchReconnectLimit(int watchReconnectLimit) {
    this.watchReconnectLimit=watchReconnectLimit; return (A) this;
  }
  public java.lang.Boolean hasWatchReconnectLimit() {
    return true;
  }
  public int getConnectionTimeout() {
    return this.connectionTimeout;
  }
  public A withConnectionTimeout(int connectionTimeout) {
    this.connectionTimeout=connectionTimeout; return (A) this;
  }
  public java.lang.Boolean hasConnectionTimeout() {
    return true;
  }
  public int getUploadConnectionTimeout() {
    return this.uploadConnectionTimeout;
  }
  public A withUploadConnectionTimeout(int uploadConnectionTimeout) {
    this.uploadConnectionTimeout=uploadConnectionTimeout; return (A) this;
  }
  public java.lang.Boolean hasUploadConnectionTimeout() {
    return true;
  }
  public int getUploadRequestTimeout() {
    return this.uploadRequestTimeout;
  }
  public A withUploadRequestTimeout(int uploadRequestTimeout) {
    this.uploadRequestTimeout=uploadRequestTimeout; return (A) this;
  }
  public java.lang.Boolean hasUploadRequestTimeout() {
    return true;
  }
  public int getRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit;
  }
  public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
    this.requestRetryBackoffLimit=requestRetryBackoffLimit; return (A) this;
  }
  public java.lang.Boolean hasRequestRetryBackoffLimit() {
    return true;
  }
  public int getRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval;
  }
  public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
    this.requestRetryBackoffInterval=requestRetryBackoffInterval; return (A) this;
  }
  public java.lang.Boolean hasRequestRetryBackoffInterval() {
    return true;
  }
  public int getRequestTimeout() {
    return this.requestTimeout;
  }
  public A withRequestTimeout(int requestTimeout) {
    this.requestTimeout=requestTimeout; return (A) this;
  }
  public java.lang.Boolean hasRequestTimeout() {
    return true;
  }
  public long getRollingTimeout() {
    return this.rollingTimeout;
  }
  public A withRollingTimeout(long rollingTimeout) {
    this.rollingTimeout=rollingTimeout; return (A) this;
  }
  public java.lang.Boolean hasRollingTimeout() {
    return true;
  }
  public long getScaleTimeout() {
    return this.scaleTimeout;
  }
  public A withScaleTimeout(long scaleTimeout) {
    this.scaleTimeout=scaleTimeout; return (A) this;
  }
  public java.lang.Boolean hasScaleTimeout() {
    return true;
  }
  public int getLoggingInterval() {
    return this.loggingInterval;
  }
  public A withLoggingInterval(int loggingInterval) {
    this.loggingInterval=loggingInterval; return (A) this;
  }
  public java.lang.Boolean hasLoggingInterval() {
    return true;
  }
  public long getWebsocketTimeout() {
    return this.websocketTimeout;
  }
  public A withWebsocketTimeout(long websocketTimeout) {
    this.websocketTimeout=websocketTimeout; return (A) this;
  }
  public java.lang.Boolean hasWebsocketTimeout() {
    return true;
  }
  public long getWebsocketPingInterval() {
    return this.websocketPingInterval;
  }
  public A withWebsocketPingInterval(long websocketPingInterval) {
    this.websocketPingInterval=websocketPingInterval; return (A) this;
  }
  public java.lang.Boolean hasWebsocketPingInterval() {
    return true;
  }
  public int getMaxConcurrentRequests() {
    return this.maxConcurrentRequests;
  }
  public A withMaxConcurrentRequests(int maxConcurrentRequests) {
    this.maxConcurrentRequests=maxConcurrentRequests; return (A) this;
  }
  public java.lang.Boolean hasMaxConcurrentRequests() {
    return true;
  }
  public int getMaxConcurrentRequestsPerHost() {
    return this.maxConcurrentRequestsPerHost;
  }
  public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
    this.maxConcurrentRequestsPerHost=maxConcurrentRequestsPerHost; return (A) this;
  }
  public java.lang.Boolean hasMaxConcurrentRequestsPerHost() {
    return true;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestConfigFluentImpl that = (RequestConfigFluentImpl) o;
    if (username != null ? !username.equals(that.username) :that.username != null) return false;
    if (password != null ? !password.equals(that.password) :that.password != null) return false;
    if (oauthToken != null ? !oauthToken.equals(that.oauthToken) :that.oauthToken != null) return false;
    if (oauthTokenProvider != null ? !oauthTokenProvider.equals(that.oauthTokenProvider) :that.oauthTokenProvider != null) return false;
    if (impersonateUsername != null ? !impersonateUsername.equals(that.impersonateUsername) :that.impersonateUsername != null) return false;
    if (impersonateGroups != null ? !impersonateGroups.equals(that.impersonateGroups) :that.impersonateGroups != null) return false;
    if (impersonateExtras != null ? !impersonateExtras.equals(that.impersonateExtras) :that.impersonateExtras != null) return false;
    if (watchReconnectInterval != that.watchReconnectInterval) return false;
    if (watchReconnectLimit != that.watchReconnectLimit) return false;
    if (connectionTimeout != that.connectionTimeout) return false;
    if (uploadConnectionTimeout != that.uploadConnectionTimeout) return false;
    if (uploadRequestTimeout != that.uploadRequestTimeout) return false;
    if (requestRetryBackoffLimit != that.requestRetryBackoffLimit) return false;
    if (requestRetryBackoffInterval != that.requestRetryBackoffInterval) return false;
    if (requestTimeout != that.requestTimeout) return false;
    if (rollingTimeout != that.rollingTimeout) return false;
    if (scaleTimeout != that.scaleTimeout) return false;
    if (loggingInterval != that.loggingInterval) return false;
    if (websocketTimeout != that.websocketTimeout) return false;
    if (websocketPingInterval != that.websocketPingInterval) return false;
    if (maxConcurrentRequests != that.maxConcurrentRequests) return false;
    if (maxConcurrentRequestsPerHost != that.maxConcurrentRequestsPerHost) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(username,  password,  oauthToken,  oauthTokenProvider,  impersonateUsername,  impersonateGroups,  impersonateExtras,  watchReconnectInterval,  watchReconnectLimit,  connectionTimeout,  uploadConnectionTimeout,  uploadRequestTimeout,  requestRetryBackoffLimit,  requestRetryBackoffInterval,  requestTimeout,  rollingTimeout,  scaleTimeout,  loggingInterval,  websocketTimeout,  websocketPingInterval,  maxConcurrentRequests,  maxConcurrentRequestsPerHost,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (oauthToken != null) { sb.append("oauthToken:"); sb.append(oauthToken + ","); }
    if (oauthTokenProvider != null) { sb.append("oauthTokenProvider:"); sb.append(oauthTokenProvider + ","); }
    if (impersonateUsername != null) { sb.append("impersonateUsername:"); sb.append(impersonateUsername + ","); }
    if (impersonateGroups != null && !impersonateGroups.isEmpty()) { sb.append("impersonateGroups:"); sb.append(impersonateGroups + ","); }
    if (impersonateExtras != null && !impersonateExtras.isEmpty()) { sb.append("impersonateExtras:"); sb.append(impersonateExtras + ","); }
    sb.append("watchReconnectInterval:"); sb.append(watchReconnectInterval + ",");
    sb.append("watchReconnectLimit:"); sb.append(watchReconnectLimit + ",");
    sb.append("connectionTimeout:"); sb.append(connectionTimeout + ",");
    sb.append("uploadConnectionTimeout:"); sb.append(uploadConnectionTimeout + ",");
    sb.append("uploadRequestTimeout:"); sb.append(uploadRequestTimeout + ",");
    sb.append("requestRetryBackoffLimit:"); sb.append(requestRetryBackoffLimit + ",");
    sb.append("requestRetryBackoffInterval:"); sb.append(requestRetryBackoffInterval + ",");
    sb.append("requestTimeout:"); sb.append(requestTimeout + ",");
    sb.append("rollingTimeout:"); sb.append(rollingTimeout + ",");
    sb.append("scaleTimeout:"); sb.append(scaleTimeout + ",");
    sb.append("loggingInterval:"); sb.append(loggingInterval + ",");
    sb.append("websocketTimeout:"); sb.append(websocketTimeout + ",");
    sb.append("websocketPingInterval:"); sb.append(websocketPingInterval + ",");
    sb.append("maxConcurrentRequests:"); sb.append(maxConcurrentRequests + ",");
    sb.append("maxConcurrentRequestsPerHost:"); sb.append(maxConcurrentRequestsPerHost);
    sb.append("}");
    return sb.toString();
  }
  
}