package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.client.http.TlsVersion;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{
  public boolean isTrustCerts();
  public A withTrustCerts(boolean trustCerts);
  public Boolean hasTrustCerts();
  public boolean isDisableHostnameVerification();
  public A withDisableHostnameVerification(boolean disableHostnameVerification);
  public java.lang.Boolean hasDisableHostnameVerification();
  public String getMasterUrl();
  public A withMasterUrl(java.lang.String masterUrl);
  public java.lang.Boolean hasMasterUrl();
  public java.lang.String getApiVersion();
  public A withApiVersion(java.lang.String apiVersion);
  public java.lang.Boolean hasApiVersion();
  public java.lang.String getNamespace();
  public A withNamespace(java.lang.String namespace);
  public java.lang.Boolean hasNamespace();
  public boolean isDefaultNamespace();
  public A withDefaultNamespace(boolean defaultNamespace);
  public java.lang.Boolean hasDefaultNamespace();
  public java.lang.String getCaCertFile();
  public A withCaCertFile(java.lang.String caCertFile);
  public java.lang.Boolean hasCaCertFile();
  public java.lang.String getCaCertData();
  public A withCaCertData(java.lang.String caCertData);
  public java.lang.Boolean hasCaCertData();
  public java.lang.String getClientCertFile();
  public A withClientCertFile(java.lang.String clientCertFile);
  public java.lang.Boolean hasClientCertFile();
  public java.lang.String getClientCertData();
  public A withClientCertData(java.lang.String clientCertData);
  public java.lang.Boolean hasClientCertData();
  public java.lang.String getClientKeyFile();
  public A withClientKeyFile(java.lang.String clientKeyFile);
  public java.lang.Boolean hasClientKeyFile();
  public java.lang.String getClientKeyData();
  public A withClientKeyData(java.lang.String clientKeyData);
  public java.lang.Boolean hasClientKeyData();
  public java.lang.String getClientKeyAlgo();
  public A withClientKeyAlgo(java.lang.String clientKeyAlgo);
  public java.lang.Boolean hasClientKeyAlgo();
  public java.lang.String getClientKeyPassphrase();
  public A withClientKeyPassphrase(java.lang.String clientKeyPassphrase);
  public java.lang.Boolean hasClientKeyPassphrase();
  public java.lang.String getTrustStoreFile();
  public A withTrustStoreFile(java.lang.String trustStoreFile);
  public java.lang.Boolean hasTrustStoreFile();
  public java.lang.String getTrustStorePassphrase();
  public A withTrustStorePassphrase(java.lang.String trustStorePassphrase);
  public java.lang.Boolean hasTrustStorePassphrase();
  public java.lang.String getKeyStoreFile();
  public A withKeyStoreFile(java.lang.String keyStoreFile);
  public java.lang.Boolean hasKeyStoreFile();
  public java.lang.String getKeyStorePassphrase();
  public A withKeyStorePassphrase(java.lang.String keyStorePassphrase);
  public java.lang.Boolean hasKeyStorePassphrase();
  public AuthProviderConfig getAuthProvider();
  public A withAuthProvider(io.fabric8.kubernetes.api.model.AuthProviderConfig authProvider);
  public java.lang.Boolean hasAuthProvider();
  public A addToContexts(Integer index,NamedContext item);
  public A setToContexts(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item);
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A addAllToContexts(Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A removeAllFromContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
  public List<io.fabric8.kubernetes.api.model.NamedContext> getContexts();
  public io.fabric8.kubernetes.api.model.NamedContext getContext(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.NamedContext getFirstContext();
  public io.fabric8.kubernetes.api.model.NamedContext getLastContext();
  public io.fabric8.kubernetes.api.model.NamedContext getMatchingContext(Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate);
  public java.lang.Boolean hasMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate);
  public A withContexts(java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts);
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts);
  public java.lang.Boolean hasContexts();
  public io.fabric8.kubernetes.api.model.NamedContext getCurrentContext();
  public A withCurrentContext(io.fabric8.kubernetes.api.model.NamedContext currentContext);
  public java.lang.Boolean hasCurrentContext();
  public java.lang.String getUsername();
  public A withUsername(java.lang.String username);
  public java.lang.Boolean hasUsername();
  public java.lang.String getPassword();
  public A withPassword(java.lang.String password);
  public java.lang.Boolean hasPassword();
  public java.lang.String getOauthToken();
  public A withOauthToken(java.lang.String oauthToken);
  public java.lang.Boolean hasOauthToken();
  public int getWatchReconnectInterval();
  public A withWatchReconnectInterval(int watchReconnectInterval);
  public java.lang.Boolean hasWatchReconnectInterval();
  public int getWatchReconnectLimit();
  public A withWatchReconnectLimit(int watchReconnectLimit);
  public java.lang.Boolean hasWatchReconnectLimit();
  public int getConnectionTimeout();
  public A withConnectionTimeout(int connectionTimeout);
  public java.lang.Boolean hasConnectionTimeout();
  public int getUploadConnectionTimeout();
  public A withUploadConnectionTimeout(int uploadConnectionTimeout);
  public java.lang.Boolean hasUploadConnectionTimeout();
  public int getUploadRequestTimeout();
  public A withUploadRequestTimeout(int uploadRequestTimeout);
  public java.lang.Boolean hasUploadRequestTimeout();
  public int getRequestRetryBackoffLimit();
  public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit);
  public java.lang.Boolean hasRequestRetryBackoffLimit();
  public int getRequestRetryBackoffInterval();
  public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval);
  public java.lang.Boolean hasRequestRetryBackoffInterval();
  public int getRequestTimeout();
  public A withRequestTimeout(int requestTimeout);
  public java.lang.Boolean hasRequestTimeout();
  public long getRollingTimeout();
  public A withRollingTimeout(long rollingTimeout);
  public java.lang.Boolean hasRollingTimeout();
  public long getScaleTimeout();
  public A withScaleTimeout(long scaleTimeout);
  public java.lang.Boolean hasScaleTimeout();
  public int getLoggingInterval();
  public A withLoggingInterval(int loggingInterval);
  public java.lang.Boolean hasLoggingInterval();
  public long getWebsocketTimeout();
  public A withWebsocketTimeout(long websocketTimeout);
  public java.lang.Boolean hasWebsocketTimeout();
  public long getWebsocketPingInterval();
  public A withWebsocketPingInterval(long websocketPingInterval);
  public java.lang.Boolean hasWebsocketPingInterval();
  public int getMaxConcurrentRequests();
  public A withMaxConcurrentRequests(int maxConcurrentRequests);
  public java.lang.Boolean hasMaxConcurrentRequests();
  public int getMaxConcurrentRequestsPerHost();
  public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost);
  public java.lang.Boolean hasMaxConcurrentRequestsPerHost();
  public java.lang.String getImpersonateUsername();
  public A withImpersonateUsername(java.lang.String impersonateUsername);
  public java.lang.Boolean hasImpersonateUsername();
  public OAuthTokenProvider getOauthTokenProvider();
  public A withOauthTokenProvider(io.fabric8.kubernetes.client.OAuthTokenProvider oauthTokenProvider);
  public java.lang.Boolean hasOauthTokenProvider();
  public java.lang.String getImpersonateGroup();
  public A withImpersonateGroup(java.lang.String impersonateGroup);
  public java.lang.Boolean hasImpersonateGroup();
  public A withImpersonateGroups(java.lang.String... impersonateGroups);
  public java.lang.String[] getImpersonateGroups();
  public A addToImpersonateGroups(java.lang.Integer index,java.lang.String item);
  public A setToImpersonateGroups(java.lang.Integer index,java.lang.String item);
  public A addToImpersonateGroups(java.lang.String... items);
  public A addAllToImpersonateGroups(java.util.Collection<java.lang.String> items);
  public A removeFromImpersonateGroups(java.lang.String... items);
  public A removeAllFromImpersonateGroups(java.util.Collection<java.lang.String> items);
  public java.lang.Boolean hasImpersonateGroups();
  public A addToImpersonateExtras(java.lang.String key,java.util.List<java.lang.String> value);
  public A addToImpersonateExtras(Map<java.lang.String,java.util.List<java.lang.String>> map);
  public A removeFromImpersonateExtras(java.lang.String key);
  public A removeFromImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map);
  public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getImpersonateExtras();
  public <K,V>A withImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras);
  public java.lang.Boolean hasImpersonateExtras();
  public boolean isHttp2Disable();
  public A withHttp2Disable(boolean http2Disable);
  public java.lang.Boolean hasHttp2Disable();
  public java.lang.String getHttpProxy();
  public A withHttpProxy(java.lang.String httpProxy);
  public java.lang.Boolean hasHttpProxy();
  public java.lang.String getHttpsProxy();
  public A withHttpsProxy(java.lang.String httpsProxy);
  public java.lang.Boolean hasHttpsProxy();
  public java.lang.String getProxyUsername();
  public A withProxyUsername(java.lang.String proxyUsername);
  public java.lang.Boolean hasProxyUsername();
  public java.lang.String getProxyPassword();
  public A withProxyPassword(java.lang.String proxyPassword);
  public java.lang.Boolean hasProxyPassword();
  public A withNoProxy(java.lang.String... noProxy);
  public java.lang.String[] getNoProxy();
  public A addToNoProxy(java.lang.Integer index,java.lang.String item);
  public A setToNoProxy(java.lang.Integer index,java.lang.String item);
  public A addToNoProxy(java.lang.String... items);
  public A addAllToNoProxy(java.util.Collection<java.lang.String> items);
  public A removeFromNoProxy(java.lang.String... items);
  public A removeAllFromNoProxy(java.util.Collection<java.lang.String> items);
  public java.lang.Boolean hasNoProxy();
  public java.lang.String getUserAgent();
  public A withUserAgent(java.lang.String userAgent);
  public java.lang.Boolean hasUserAgent();
  public A withTlsVersions(TlsVersion... tlsVersions);
  public io.fabric8.kubernetes.client.http.TlsVersion[] getTlsVersions();
  public A addToTlsVersions(java.lang.Integer index,io.fabric8.kubernetes.client.http.TlsVersion item);
  public A setToTlsVersions(java.lang.Integer index,io.fabric8.kubernetes.client.http.TlsVersion item);
  public A addToTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items);
  public A addAllToTlsVersions(java.util.Collection<io.fabric8.kubernetes.client.http.TlsVersion> items);
  public A removeFromTlsVersions(io.fabric8.kubernetes.client.http.TlsVersion... items);
  public A removeAllFromTlsVersions(java.util.Collection<io.fabric8.kubernetes.client.http.TlsVersion> items);
  public java.lang.Boolean hasTlsVersions();
  public A addToErrorMessages(java.lang.Integer key,java.lang.String value);
  public A addToErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map);
  public A removeFromErrorMessages(java.lang.Integer key);
  public A removeFromErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map);
  public java.util.Map<java.lang.Integer,java.lang.String> getErrorMessages();
  public <K,V>A withErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> errorMessages);
  public java.lang.Boolean hasErrorMessages();
  public A addToCustomHeaders(java.lang.String key,java.lang.String value);
  public A addToCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map);
  public A removeFromCustomHeaders(java.lang.String key);
  public A removeFromCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map);
  public java.util.Map<java.lang.String,java.lang.String> getCustomHeaders();
  public <K,V>A withCustomHeaders(java.util.Map<java.lang.String,java.lang.String> customHeaders);
  public java.lang.Boolean hasCustomHeaders();
  public A withTrustCerts();
  public A withDisableHostnameVerification();
  public A withDefaultNamespace();
  public A withHttp2Disable();
  
}