/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch;

import io.fabric8.kubernetes.api.model.LabelSelectorAssert;
import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractJobSpecAssert<S extends AbstractJobSpecAssert<S, A>, A extends JobSpec>
extends AbstractAssert<S, A> {
    protected AbstractJobSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualActiveDeadlineSeconds = ((JobSpec)this.actual).getActiveDeadlineSeconds();
        if (!Objects.areEqual((Object)actualActiveDeadlineSeconds, (Object)activeDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, activeDeadlineSeconds, actualActiveDeadlineSeconds});
        }
        return (S)((Object)((AbstractJobSpecAssert)this.myself));
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((JobSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasBackoffLimit(Integer backoffLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting backoffLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualBackoffLimit = ((JobSpec)this.actual).getBackoffLimit();
        if (!Objects.areEqual((Object)actualBackoffLimit, (Object)backoffLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, backoffLimit, actualBackoffLimit});
        }
        return (S)((Object)((AbstractJobSpecAssert)this.myself));
    }

    public S hasCompletions(Integer completions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting completions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualCompletions = ((JobSpec)this.actual).getCompletions();
        if (!Objects.areEqual((Object)actualCompletions, (Object)completions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, completions, actualCompletions});
        }
        return (S)((Object)((AbstractJobSpecAssert)this.myself));
    }

    public BooleanAssert manualSelector() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((JobSpec)this.actual).getManualSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "manualSelector"), new Object[0]);
    }

    public S hasParallelism(Integer parallelism) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parallelism of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualParallelism = ((JobSpec)this.actual).getParallelism();
        if (!Objects.areEqual((Object)actualParallelism, (Object)parallelism)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parallelism, actualParallelism});
        }
        return (S)((Object)((AbstractJobSpecAssert)this.myself));
    }

    public LabelSelectorAssert selector() {
        this.isNotNull();
        return (LabelSelectorAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((JobSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]));
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((JobSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]));
    }

    public S hasTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting ttlSecondsAfterFinished of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualTtlSecondsAfterFinished = ((JobSpec)this.actual).getTtlSecondsAfterFinished();
        if (!Objects.areEqual((Object)actualTtlSecondsAfterFinished, (Object)ttlSecondsAfterFinished)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ttlSecondsAfterFinished, actualTtlSecondsAfterFinished});
        }
        return (S)((Object)((AbstractJobSpecAssert)this.myself));
    }
}

