/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.LabelSelectorAssert;
import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractReplicaSetSpecAssert<S extends AbstractReplicaSetSpecAssert<S, A>, A extends ReplicaSetSpec>
extends AbstractAssert<S, A> {
    protected AbstractReplicaSetSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ReplicaSetSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasMinReadySeconds(Integer minReadySeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualMinReadySeconds = ((ReplicaSetSpec)this.actual).getMinReadySeconds();
        if (!Objects.areEqual((Object)actualMinReadySeconds, (Object)minReadySeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, minReadySeconds, actualMinReadySeconds});
        }
        return (S)((Object)((AbstractReplicaSetSpecAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((ReplicaSetSpec)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractReplicaSetSpecAssert)this.myself));
    }

    public LabelSelectorAssert selector() {
        this.isNotNull();
        return (LabelSelectorAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ReplicaSetSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]));
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ReplicaSetSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]));
    }
}

