/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import io.fabric8.kubernetes.api.model.apps.DeploymentConditionAssert;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDeploymentStatusAssert<S extends AbstractDeploymentStatusAssert<S, A>, A extends DeploymentStatus>
extends AbstractAssert<S, A> {
    protected AbstractDeploymentStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((DeploymentStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasAvailableReplicas(Integer availableReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualAvailableReplicas = ((DeploymentStatus)this.actual).getAvailableReplicas();
        if (!Objects.areEqual((Object)actualAvailableReplicas, (Object)availableReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, availableReplicas, actualAvailableReplicas});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public S hasCollisionCount(Integer collisionCount) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting collisionCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualCollisionCount = ((DeploymentStatus)this.actual).getCollisionCount();
        if (!Objects.areEqual((Object)actualCollisionCount, (Object)collisionCount)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, collisionCount, actualCollisionCount});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<DeploymentCondition, DeploymentConditionAssert> assertFactory = new AssertFactory<DeploymentCondition, DeploymentConditionAssert>(){

            public DeploymentConditionAssert createAssert(DeploymentCondition t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> answer = new NavigationListAssert<DeploymentCondition, DeploymentConditionAssert>(((DeploymentStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public S hasObservedGeneration(Long observedGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualObservedGeneration = ((DeploymentStatus)this.actual).getObservedGeneration();
        if (!Objects.areEqual((Object)actualObservedGeneration, (Object)observedGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, observedGeneration, actualObservedGeneration});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public S hasReadyReplicas(Integer readyReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReadyReplicas = ((DeploymentStatus)this.actual).getReadyReplicas();
        if (!Objects.areEqual((Object)actualReadyReplicas, (Object)readyReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, readyReplicas, actualReadyReplicas});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((DeploymentStatus)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public S hasUnavailableReplicas(Integer unavailableReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting unavailableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualUnavailableReplicas = ((DeploymentStatus)this.actual).getUnavailableReplicas();
        if (!Objects.areEqual((Object)actualUnavailableReplicas, (Object)unavailableReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, unavailableReplicas, actualUnavailableReplicas});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }

    public S hasUpdatedReplicas(Integer updatedReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualUpdatedReplicas = ((DeploymentStatus)this.actual).getUpdatedReplicas();
        if (!Objects.areEqual((Object)actualUpdatedReplicas, (Object)updatedReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, updatedReplicas, actualUpdatedReplicas});
        }
        return (S)((Object)((AbstractDeploymentStatusAssert)this.myself));
    }
}

