/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.LabelSelectorAssert;
import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategyAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDeploymentSpecAssert<S extends AbstractDeploymentSpecAssert<S, A>, A extends DeploymentSpec>
extends AbstractAssert<S, A> {
    protected AbstractDeploymentSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((DeploymentSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasMinReadySeconds(Integer minReadySeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualMinReadySeconds = ((DeploymentSpec)this.actual).getMinReadySeconds();
        if (!Objects.areEqual((Object)actualMinReadySeconds, (Object)minReadySeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, minReadySeconds, actualMinReadySeconds});
        }
        return (S)((Object)((AbstractDeploymentSpecAssert)this.myself));
    }

    public BooleanAssert paused() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((DeploymentSpec)this.actual).getPaused()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "paused"), new Object[0]);
    }

    public S hasProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting progressDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualProgressDeadlineSeconds = ((DeploymentSpec)this.actual).getProgressDeadlineSeconds();
        if (!Objects.areEqual((Object)actualProgressDeadlineSeconds, (Object)progressDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, progressDeadlineSeconds, actualProgressDeadlineSeconds});
        }
        return (S)((Object)((AbstractDeploymentSpecAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((DeploymentSpec)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractDeploymentSpecAssert)this.myself));
    }

    public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualRevisionHistoryLimit = ((DeploymentSpec)this.actual).getRevisionHistoryLimit();
        if (!Objects.areEqual((Object)actualRevisionHistoryLimit, (Object)revisionHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, revisionHistoryLimit, actualRevisionHistoryLimit});
        }
        return (S)((Object)((AbstractDeploymentSpecAssert)this.myself));
    }

    public LabelSelectorAssert selector() {
        this.isNotNull();
        return (LabelSelectorAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((DeploymentSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]));
    }

    public DeploymentStrategyAssert strategy() {
        this.isNotNull();
        return (DeploymentStrategyAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((DeploymentSpec)this.actual).getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"), new Object[0]));
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((DeploymentSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]));
    }
}

