/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.CapabilitiesAssert;
import io.fabric8.kubernetes.api.model.SELinuxOptionsAssert;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractSecurityContextAssert<S extends AbstractSecurityContextAssert<S, A>, A extends SecurityContext>
extends AbstractAssert<S, A> {
    protected AbstractSecurityContextAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((SecurityContext)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public BooleanAssert allowPrivilegeEscalation() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContext)this.actual).getAllowPrivilegeEscalation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowPrivilegeEscalation"), new Object[0]);
    }

    public CapabilitiesAssert capabilities() {
        this.isNotNull();
        return (CapabilitiesAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((SecurityContext)this.actual).getCapabilities()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capabilities"), new Object[0]));
    }

    public BooleanAssert privileged() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContext)this.actual).getPrivileged()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "privileged"), new Object[0]);
    }

    public StringAssert procMount() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((SecurityContext)this.actual).getProcMount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "procMount"), new Object[0]);
    }

    public BooleanAssert readOnlyRootFilesystem() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContext)this.actual).getReadOnlyRootFilesystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnlyRootFilesystem"), new Object[0]);
    }

    public S hasRunAsGroup(Long runAsGroup) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting runAsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualRunAsGroup = ((SecurityContext)this.actual).getRunAsGroup();
        if (!Objects.areEqual((Object)actualRunAsGroup, (Object)runAsGroup)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, runAsGroup, actualRunAsGroup});
        }
        return (S)((Object)((AbstractSecurityContextAssert)this.myself));
    }

    public BooleanAssert runAsNonRoot() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContext)this.actual).getRunAsNonRoot()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsNonRoot"), new Object[0]);
    }

    public S hasRunAsUser(Long runAsUser) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualRunAsUser = ((SecurityContext)this.actual).getRunAsUser();
        if (!Objects.areEqual((Object)actualRunAsUser, (Object)runAsUser)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, runAsUser, actualRunAsUser});
        }
        return (S)((Object)((AbstractSecurityContextAssert)this.myself));
    }

    public SELinuxOptionsAssert seLinuxOptions() {
        this.isNotNull();
        return (SELinuxOptionsAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((SecurityContext)this.actual).getSeLinuxOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxOptions"), new Object[0]));
    }

    public WindowsSecurityContextOptionsAssert windowsOptions() {
        this.isNotNull();
        return (WindowsSecurityContextOptionsAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((SecurityContext)this.actual).getWindowsOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "windowsOptions"), new Object[0]));
    }
}

