/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerCondition;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerConditionAssert;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.MetricStatus;
import io.fabric8.kubernetes.api.model.MetricStatusAssert;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractHorizontalPodAutoscalerStatusAssert<S extends AbstractHorizontalPodAutoscalerStatusAssert<S, A>, A extends HorizontalPodAutoscalerStatus>
extends AbstractAssert<S, A> {
    protected AbstractHorizontalPodAutoscalerStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((HorizontalPodAutoscalerStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public NavigationListAssert<HorizontalPodAutoscalerCondition, HorizontalPodAutoscalerConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<HorizontalPodAutoscalerCondition, HorizontalPodAutoscalerConditionAssert> assertFactory = new AssertFactory<HorizontalPodAutoscalerCondition, HorizontalPodAutoscalerConditionAssert>(){

            public HorizontalPodAutoscalerConditionAssert createAssert(HorizontalPodAutoscalerCondition t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<HorizontalPodAutoscalerCondition, HorizontalPodAutoscalerConditionAssert> answer = new NavigationListAssert<HorizontalPodAutoscalerCondition, HorizontalPodAutoscalerConditionAssert>(((HorizontalPodAutoscalerStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<MetricStatus, MetricStatusAssert> currentMetrics() {
        this.isNotNull();
        AssertFactory<MetricStatus, MetricStatusAssert> assertFactory = new AssertFactory<MetricStatus, MetricStatusAssert>(){

            public MetricStatusAssert createAssert(MetricStatus t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<MetricStatus, MetricStatusAssert> answer = new NavigationListAssert<MetricStatus, MetricStatusAssert>(((HorizontalPodAutoscalerStatus)this.actual).getCurrentMetrics(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "currentMetrics"), new Object[0]);
        return answer;
    }

    public S hasCurrentReplicas(Integer currentReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting currentReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualCurrentReplicas = ((HorizontalPodAutoscalerStatus)this.actual).getCurrentReplicas();
        if (!Objects.areEqual((Object)actualCurrentReplicas, (Object)currentReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, currentReplicas, actualCurrentReplicas});
        }
        return (S)((Object)((AbstractHorizontalPodAutoscalerStatusAssert)this.myself));
    }

    public S hasDesiredReplicas(Integer desiredReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting desiredReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualDesiredReplicas = ((HorizontalPodAutoscalerStatus)this.actual).getDesiredReplicas();
        if (!Objects.areEqual((Object)actualDesiredReplicas, (Object)desiredReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, desiredReplicas, actualDesiredReplicas});
        }
        return (S)((Object)((AbstractHorizontalPodAutoscalerStatusAssert)this.myself));
    }

    public StringAssert lastScaleTime() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((HorizontalPodAutoscalerStatus)this.actual).getLastScaleTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastScaleTime"), new Object[0]);
    }

    public S hasObservedGeneration(Long observedGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualObservedGeneration = ((HorizontalPodAutoscalerStatus)this.actual).getObservedGeneration();
        if (!Objects.areEqual((Object)actualObservedGeneration, (Object)observedGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, observedGeneration, actualObservedGeneration});
        }
        return (S)((Object)((AbstractHorizontalPodAutoscalerStatusAssert)this.myself));
    }
}

