package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TagReference} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagReferenceAssert<S extends AbstractTagReferenceAssert<S, A>, A extends TagReference> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagReferenceAssert}</code> to make assertions on actual TagReference.
   * @param actual the TagReference we want to make assertions on.
   */
  protected AbstractTagReferenceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property annotations so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert annotations()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "annotations"));
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Verifies that the actual TagReference's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagReference's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property importPolicy so that assertions can be done on it
   */
  public TagImportPolicyAssert importPolicy()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TagImportPolicyAssert) assertThat(actual.getImportPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "importPolicy"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property reference so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert reference()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reference"));
  }


  /**
   * Navigates to the property referencePolicy so that assertions can be done on it
   */
  public TagReferencePolicyAssert referencePolicy()  {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TagReferencePolicyAssert) assertThat(actual.getReferencePolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "referencePolicy"));
  }


}
