package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TagImageHook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagImageHookAssert<S extends AbstractTagImageHookAssert<S, A>, A extends TagImageHook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagImageHookAssert}</code> to make assertions on actual TagImageHook.
   * @param actual the TagImageHook we want to make assertions on.
   */
  protected AbstractTagImageHookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property containerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert containerName()  {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainerName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerName"));
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert to()  {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
  }


}
