package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link TagEventCondition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagEventConditionAssert<S extends AbstractTagEventConditionAssert<S, A>, A extends TagEventCondition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagEventConditionAssert}</code> to make assertions on actual TagEventCondition.
   * @param actual the TagEventCondition we want to make assertions on.
   */
  protected AbstractTagEventConditionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual TagEventCondition's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagEventCondition's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventCondition's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property lastTransitionTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastTransitionTime()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastTransitionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTransitionTime"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert status()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual TagEventCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
