package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SubjectAccessReview} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewAssert<S extends AbstractSubjectAccessReviewAssert<S, A>, A extends SubjectAccessReview> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewAssert}</code> to make assertions on actual SubjectAccessReview.
   * @param actual the SubjectAccessReview we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property content so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.HasMetadataAssert content()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(actual.getContent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "content"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property isNonResourceURL so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert isNonResourceURL()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getIsNonResourceURL()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "isNonResourceURL"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property resource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resource()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resource"));
  }


  /**
   * Navigates to the property resourceAPIGroup so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceAPIGroup()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceAPIGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceAPIGroup"));
  }


  /**
   * Navigates to the property resourceAPIVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceAPIVersion()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceAPIVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceAPIVersion"));
  }


  /**
   * Navigates to the property resourceName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceName()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceName"));
  }


  /**
   * Navigates to the property scopes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> scopes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getScopes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopes"));
    return answer;
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


  /**
   * Navigates to the property verb so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert verb()  {
    // check that actual SubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVerb()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "verb"));
  }


}
