package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StepInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStepInfoAssert<S extends AbstractStepInfoAssert<S, A>, A extends StepInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStepInfoAssert}</code> to make assertions on actual StepInfo.
   * @param actual the StepInfo we want to make assertions on.
   */
  protected AbstractStepInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StepInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual StepInfo's durationMilliseconds is equal to the given one.
   * @param durationMilliseconds the given durationMilliseconds to compare the actual StepInfo's durationMilliseconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StepInfo's durationMilliseconds is not equal to the given one.
   */
  public S hasDurationMilliseconds(Long durationMilliseconds) {
    // check that actual StepInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting durationMilliseconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDurationMilliseconds = actual.getDurationMilliseconds();
    if (!Objects.areEqual(actualDurationMilliseconds, durationMilliseconds)) {
      failWithMessage(assertjErrorMessage, actual, durationMilliseconds, actualDurationMilliseconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual StepInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property startTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startTime()  {
    // check that actual StepInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"));
  }


}
