package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SignatureIssuer} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSignatureIssuerAssert<S extends AbstractSignatureIssuerAssert<S, A>, A extends SignatureIssuer> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSignatureIssuerAssert}</code> to make assertions on actual SignatureIssuer.
   * @param actual the SignatureIssuer we want to make assertions on.
   */
  protected AbstractSignatureIssuerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SignatureIssuer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property commonName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert commonName()  {
    // check that actual SignatureIssuer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCommonName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "commonName"));
  }


  /**
   * Navigates to the property organization so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert organization()  {
    // check that actual SignatureIssuer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOrganization()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "organization"));
  }


}
