package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SELinuxContextStrategyOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSELinuxContextStrategyOptionsAssert<S extends AbstractSELinuxContextStrategyOptionsAssert<S, A>, A extends SELinuxContextStrategyOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSELinuxContextStrategyOptionsAssert}</code> to make assertions on actual SELinuxContextStrategyOptions.
   * @param actual the SELinuxContextStrategyOptions we want to make assertions on.
   */
  protected AbstractSELinuxContextStrategyOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property seLinuxOptions so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.SELinuxOptionsAssert seLinuxOptions()  {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.SELinuxOptionsAssert) assertThat(actual.getSeLinuxOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxOptions"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual SELinuxContextStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
