package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RunAsUserStrategyOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRunAsUserStrategyOptionsAssert<S extends AbstractRunAsUserStrategyOptionsAssert<S, A>, A extends RunAsUserStrategyOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRunAsUserStrategyOptionsAssert}</code> to make assertions on actual RunAsUserStrategyOptions.
   * @param actual the RunAsUserStrategyOptions we want to make assertions on.
   */
  protected AbstractRunAsUserStrategyOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RunAsUserStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual RunAsUserStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


  /**
   * Verifies that the actual RunAsUserStrategyOptions's uid is equal to the given one.
   * @param uid the given uid to compare the actual RunAsUserStrategyOptions's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RunAsUserStrategyOptions's uid is not equal to the given one.
   */
  public S hasUid(Long uid) {
    // check that actual RunAsUserStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RunAsUserStrategyOptions's uidRangeMax is equal to the given one.
   * @param uidRangeMax the given uidRangeMax to compare the actual RunAsUserStrategyOptions's uidRangeMax to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RunAsUserStrategyOptions's uidRangeMax is not equal to the given one.
   */
  public S hasUidRangeMax(Long uidRangeMax) {
    // check that actual RunAsUserStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uidRangeMax of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualUidRangeMax = actual.getUidRangeMax();
    if (!Objects.areEqual(actualUidRangeMax, uidRangeMax)) {
      failWithMessage(assertjErrorMessage, actual, uidRangeMax, actualUidRangeMax);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RunAsUserStrategyOptions's uidRangeMin is equal to the given one.
   * @param uidRangeMin the given uidRangeMin to compare the actual RunAsUserStrategyOptions's uidRangeMin to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RunAsUserStrategyOptions's uidRangeMin is not equal to the given one.
   */
  public S hasUidRangeMin(Long uidRangeMin) {
    // check that actual RunAsUserStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uidRangeMin of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualUidRangeMin = actual.getUidRangeMin();
    if (!Objects.areEqual(actualUidRangeMin, uidRangeMin)) {
      failWithMessage(assertjErrorMessage, actual, uidRangeMin, actualUidRangeMin);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
