package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RouteStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteStatusAssert<S extends AbstractRouteStatusAssert<S, A>, A extends RouteStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteStatusAssert}</code> to make assertions on actual RouteStatus.
   * @param actual the RouteStatus we want to make assertions on.
   */
  protected AbstractRouteStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ingress so that assertions can be done on it
   */
  public NavigationListAssert<RouteIngress, RouteIngressAssert> ingress()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<RouteIngress, RouteIngressAssert> assertFactory = new AssertFactory<RouteIngress, RouteIngressAssert>() {
      public RouteIngressAssert createAssert(RouteIngress t) {
        return (RouteIngressAssert) assertThat(t);
      }
    };
    NavigationListAssert<RouteIngress, RouteIngressAssert> answer = new NavigationListAssert<RouteIngress, RouteIngressAssert>(actual.getIngress(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingress"));
    return answer;
  }


}
