package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ProjectStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectStatusAssert<S extends AbstractProjectStatusAssert<S, A>, A extends ProjectStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectStatusAssert}</code> to make assertions on actual ProjectStatus.
   * @param actual the ProjectStatus we want to make assertions on.
   */
  protected AbstractProjectStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ProjectStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.NamespaceCondition, io.fabric8.kubernetes.api.model.NamespaceConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.NamespaceCondition, io.fabric8.kubernetes.api.model.NamespaceConditionAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.NamespaceCondition, io.fabric8.kubernetes.api.model.NamespaceConditionAssert>() {
      public io.fabric8.kubernetes.api.model.NamespaceConditionAssert createAssert(io.fabric8.kubernetes.api.model.NamespaceCondition t) {
        return (io.fabric8.kubernetes.api.model.NamespaceConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.NamespaceCondition, io.fabric8.kubernetes.api.model.NamespaceConditionAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.NamespaceCondition, io.fabric8.kubernetes.api.model.NamespaceConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property phase so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert phase()  {
    // check that actual ProjectStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"));
  }


}
