package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Parameter} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractParameterAssert<S extends AbstractParameterAssert<S, A>, A extends Parameter> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractParameterAssert}</code> to make assertions on actual Parameter.
   * @param actual the Parameter we want to make assertions on.
   */
  protected AbstractParameterAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property description so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert description()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDescription()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "description"));
  }


  /**
   * Navigates to the property displayName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert displayName()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDisplayName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "displayName"));
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert from()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property generate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert generate()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGenerate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "generate"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property required so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert required()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getRequired()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "required"));
  }


  /**
   * Navigates to the property value so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert value()  {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getValue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "value"));
  }


}
