package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link OpenshiftRoleBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOpenshiftRoleBindingAssert<S extends AbstractOpenshiftRoleBindingAssert<S, A>, A extends OpenshiftRoleBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOpenshiftRoleBindingAssert}</code> to make assertions on actual OpenshiftRoleBinding.
   * @param actual the OpenshiftRoleBinding we want to make assertions on.
   */
  protected AbstractOpenshiftRoleBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OpenshiftRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OpenshiftRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property groupNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groupNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroupNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groupNames"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OpenshiftRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual OpenshiftRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property roleRef so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert roleRef()  {
    // check that actual OpenshiftRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getRoleRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleRef"));
  }


  /**
   * Navigates to the property subjects so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.ObjectReference, io.fabric8.kubernetes.api.model.ObjectReferenceAssert> subjects()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.ObjectReference, io.fabric8.kubernetes.api.model.ObjectReferenceAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.ObjectReference, io.fabric8.kubernetes.api.model.ObjectReferenceAssert>() {
      public io.fabric8.kubernetes.api.model.ObjectReferenceAssert createAssert(io.fabric8.kubernetes.api.model.ObjectReference t) {
        return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.ObjectReference, io.fabric8.kubernetes.api.model.ObjectReferenceAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.ObjectReference, io.fabric8.kubernetes.api.model.ObjectReferenceAssert>(actual.getSubjects(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjects"));
    return answer;
  }


  /**
   * Navigates to the property userNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> userNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getUserNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userNames"));
    return answer;
  }


}
