package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link OpenshiftRole} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOpenshiftRoleAssert<S extends AbstractOpenshiftRoleAssert<S, A>, A extends OpenshiftRole> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOpenshiftRoleAssert}</code> to make assertions on actual OpenshiftRole.
   * @param actual the OpenshiftRole we want to make assertions on.
   */
  protected AbstractOpenshiftRoleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OpenshiftRole we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OpenshiftRole we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OpenshiftRole we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual OpenshiftRole we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property rules so that assertions can be done on it
   */
  public NavigationListAssert<PolicyRule, PolicyRuleAssert> rules()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PolicyRule, PolicyRuleAssert> assertFactory = new AssertFactory<PolicyRule, PolicyRuleAssert>() {
      public PolicyRuleAssert createAssert(PolicyRule t) {
        return (PolicyRuleAssert) assertThat(t);
      }
    };
    NavigationListAssert<PolicyRule, PolicyRuleAssert> answer = new NavigationListAssert<PolicyRule, PolicyRuleAssert>(actual.getRules(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rules"));
    return answer;
  }


}
