package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link OpenshiftClusterRoleScopeRestriction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOpenshiftClusterRoleScopeRestrictionAssert<S extends AbstractOpenshiftClusterRoleScopeRestrictionAssert<S, A>, A extends OpenshiftClusterRoleScopeRestriction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOpenshiftClusterRoleScopeRestrictionAssert}</code> to make assertions on actual OpenshiftClusterRoleScopeRestriction.
   * @param actual the OpenshiftClusterRoleScopeRestriction we want to make assertions on.
   */
  protected AbstractOpenshiftClusterRoleScopeRestrictionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OpenshiftClusterRoleScopeRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowEscalation so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowEscalation()  {
    // check that actual OpenshiftClusterRoleScopeRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowEscalation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowEscalation"));
  }


  /**
   * Navigates to the property namespaces so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> namespaces()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNamespaces(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaces"));
    return answer;
  }


  /**
   * Navigates to the property roleNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> roleNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getRoleNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleNames"));
    return answer;
  }


}
