package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link OAuthClient} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthClientAssert<S extends AbstractOAuthClientAssert<S, A>, A extends OAuthClient> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthClientAssert}</code> to make assertions on actual OAuthClient.
   * @param actual the OAuthClient we want to make assertions on.
   */
  protected AbstractOAuthClientAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Verifies that the actual OAuthClient's accessTokenInactivityTimeoutSeconds is equal to the given one.
   * @param accessTokenInactivityTimeoutSeconds the given accessTokenInactivityTimeoutSeconds to compare the actual OAuthClient's accessTokenInactivityTimeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClient's accessTokenInactivityTimeoutSeconds is not equal to the given one.
   */
  public S hasAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting accessTokenInactivityTimeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAccessTokenInactivityTimeoutSeconds = actual.getAccessTokenInactivityTimeoutSeconds();
    if (!Objects.areEqual(actualAccessTokenInactivityTimeoutSeconds, accessTokenInactivityTimeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, accessTokenInactivityTimeoutSeconds, actualAccessTokenInactivityTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClient's accessTokenMaxAgeSeconds is equal to the given one.
   * @param accessTokenMaxAgeSeconds the given accessTokenMaxAgeSeconds to compare the actual OAuthClient's accessTokenMaxAgeSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClient's accessTokenMaxAgeSeconds is not equal to the given one.
   */
  public S hasAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting accessTokenMaxAgeSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAccessTokenMaxAgeSeconds = actual.getAccessTokenMaxAgeSeconds();
    if (!Objects.areEqual(actualAccessTokenMaxAgeSeconds, accessTokenMaxAgeSeconds)) {
      failWithMessage(assertjErrorMessage, actual, accessTokenMaxAgeSeconds, actualAccessTokenMaxAgeSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property additionalSecrets so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> additionalSecrets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAdditionalSecrets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalSecrets"));
    return answer;
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property grantMethod so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert grantMethod()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGrantMethod()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "grantMethod"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property redirectURIs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> redirectURIs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getRedirectURIs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "redirectURIs"));
    return answer;
  }


  /**
   * Navigates to the property respondWithChallenges so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert respondWithChallenges()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getRespondWithChallenges()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "respondWithChallenges"));
  }


  /**
   * Navigates to the property scopeRestrictions so that assertions can be done on it
   */
  public NavigationListAssert<ScopeRestriction, ScopeRestrictionAssert> scopeRestrictions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ScopeRestriction, ScopeRestrictionAssert> assertFactory = new AssertFactory<ScopeRestriction, ScopeRestrictionAssert>() {
      public ScopeRestrictionAssert createAssert(ScopeRestriction t) {
        return (ScopeRestrictionAssert) assertThat(t);
      }
    };
    NavigationListAssert<ScopeRestriction, ScopeRestrictionAssert> answer = new NavigationListAssert<ScopeRestriction, ScopeRestrictionAssert>(actual.getScopeRestrictions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopeRestrictions"));
    return answer;
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert secret()  {
    // check that actual OAuthClient we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


}
