package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NetNamespace} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNetNamespaceAssert<S extends AbstractNetNamespaceAssert<S, A>, A extends NetNamespace> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNetNamespaceAssert}</code> to make assertions on actual NetNamespace.
   * @param actual the NetNamespace we want to make assertions on.
   */
  protected AbstractNetNamespaceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property egressIPs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> egressIPs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getEgressIPs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "egressIPs"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Verifies that the actual NetNamespace's netid is equal to the given one.
   * @param netid the given netid to compare the actual NetNamespace's netid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NetNamespace's netid is not equal to the given one.
   */
  public S hasNetid(Integer netid) {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting netid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNetid = actual.getNetid();
    if (!Objects.areEqual(actualNetid, netid)) {
      failWithMessage(assertjErrorMessage, actual, netid, actualNetid);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property netname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert netname()  {
    // check that actual NetNamespace we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNetname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "netname"));
  }


}
