package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageStreamTag} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamTagAssert<S extends AbstractImageStreamTagAssert<S, A>, A extends ImageStreamTag> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamTagAssert}</code> to make assertions on actual ImageStreamTag.
   * @param actual the ImageStreamTag we want to make assertions on.
   */
  protected AbstractImageStreamTagAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<TagEventCondition, TagEventConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TagEventCondition, TagEventConditionAssert> assertFactory = new AssertFactory<TagEventCondition, TagEventConditionAssert>() {
      public TagEventConditionAssert createAssert(TagEventCondition t) {
        return (TagEventConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<TagEventCondition, TagEventConditionAssert> answer = new NavigationListAssert<TagEventCondition, TagEventConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Verifies that the actual ImageStreamTag's generation is equal to the given one.
   * @param generation the given generation to compare the actual ImageStreamTag's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageStreamTag's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public ImageAssert image()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property lookupPolicy so that assertions can be done on it
   */
  public ImageLookupPolicyAssert lookupPolicy()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageLookupPolicyAssert) assertThat(actual.getLookupPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lookupPolicy"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property tag so that assertions can be done on it
   */
  public TagReferenceAssert tag()  {
    // check that actual ImageStreamTag we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TagReferenceAssert) assertThat(actual.getTag()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tag"));
  }


}
