package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageStreamSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamSpecAssert<S extends AbstractImageStreamSpecAssert<S, A>, A extends ImageStreamSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamSpecAssert}</code> to make assertions on actual ImageStreamSpec.
   * @param actual the ImageStreamSpec we want to make assertions on.
   */
  protected AbstractImageStreamSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageStreamSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property dockerImageRepository so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageRepository()  {
    // check that actual ImageStreamSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageRepository()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageRepository"));
  }


  /**
   * Navigates to the property lookupPolicy so that assertions can be done on it
   */
  public ImageLookupPolicyAssert lookupPolicy()  {
    // check that actual ImageStreamSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageLookupPolicyAssert) assertThat(actual.getLookupPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lookupPolicy"));
  }


  /**
   * Navigates to the property tags so that assertions can be done on it
   */
  public NavigationListAssert<TagReference, TagReferenceAssert> tags()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TagReference, TagReferenceAssert> assertFactory = new AssertFactory<TagReference, TagReferenceAssert>() {
      public TagReferenceAssert createAssert(TagReference t) {
        return (TagReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<TagReference, TagReferenceAssert> answer = new NavigationListAssert<TagReference, TagReferenceAssert>(actual.getTags(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tags"));
    return answer;
  }


}
