package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageStreamImportStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamImportStatusAssert<S extends AbstractImageStreamImportStatusAssert<S, A>, A extends ImageStreamImportStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamImportStatusAssert}</code> to make assertions on actual ImageStreamImportStatus.
   * @param actual the ImageStreamImportStatus we want to make assertions on.
   */
  protected AbstractImageStreamImportStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageStreamImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property images so that assertions can be done on it
   */
  public NavigationListAssert<ImageImportStatus, ImageImportStatusAssert> images()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageImportStatus, ImageImportStatusAssert> assertFactory = new AssertFactory<ImageImportStatus, ImageImportStatusAssert>() {
      public ImageImportStatusAssert createAssert(ImageImportStatus t) {
        return (ImageImportStatusAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageImportStatus, ImageImportStatusAssert> answer = new NavigationListAssert<ImageImportStatus, ImageImportStatusAssert>(actual.getImages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "images"));
    return answer;
  }


  /**
   * Navigates to the property import so that assertions can be done on it
   */
  public ImageStreamAssert expectedImport()  {
    // check that actual ImageStreamImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageStreamAssert) assertThat(actual.getImport()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "import"));
  }


  /**
   * Navigates to the property repository so that assertions can be done on it
   */
  public RepositoryImportStatusAssert repository()  {
    // check that actual ImageStreamImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RepositoryImportStatusAssert) assertThat(actual.getRepository()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "repository"));
  }


}
