package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageStreamImportSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamImportSpecAssert<S extends AbstractImageStreamImportSpecAssert<S, A>, A extends ImageStreamImportSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamImportSpecAssert}</code> to make assertions on actual ImageStreamImportSpec.
   * @param actual the ImageStreamImportSpec we want to make assertions on.
   */
  protected AbstractImageStreamImportSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageStreamImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property images so that assertions can be done on it
   */
  public NavigationListAssert<ImageImportSpec, ImageImportSpecAssert> images()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageImportSpec, ImageImportSpecAssert> assertFactory = new AssertFactory<ImageImportSpec, ImageImportSpecAssert>() {
      public ImageImportSpecAssert createAssert(ImageImportSpec t) {
        return (ImageImportSpecAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageImportSpec, ImageImportSpecAssert> answer = new NavigationListAssert<ImageImportSpec, ImageImportSpecAssert>(actual.getImages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "images"));
    return answer;
  }


  /**
   * Navigates to the property import so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert expectedImport()  {
    // check that actual ImageStreamImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getImport()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "import"));
  }


  /**
   * Navigates to the property repository so that assertions can be done on it
   */
  public RepositoryImportSpecAssert repository()  {
    // check that actual ImageStreamImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RepositoryImportSpecAssert) assertThat(actual.getRepository()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "repository"));
  }


}
