package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageSourceAssert<S extends AbstractImageSourceAssert<S, A>, A extends ImageSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageSourceAssert}</code> to make assertions on actual ImageSource.
   * @param actual the ImageSource we want to make assertions on.
   */
  protected AbstractImageSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property as so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> as()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "as"));
    return answer;
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual ImageSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property paths so that assertions can be done on it
   */
  public NavigationListAssert<ImageSourcePath, ImageSourcePathAssert> paths()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageSourcePath, ImageSourcePathAssert> assertFactory = new AssertFactory<ImageSourcePath, ImageSourcePathAssert>() {
      public ImageSourcePathAssert createAssert(ImageSourcePath t) {
        return (ImageSourcePathAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageSourcePath, ImageSourcePathAssert> answer = new NavigationListAssert<ImageSourcePath, ImageSourcePathAssert>(actual.getPaths(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "paths"));
    return answer;
  }


  /**
   * Navigates to the property pullSecret so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert pullSecret()  {
    // check that actual ImageSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getPullSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pullSecret"));
  }


}
