package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageLookupPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageLookupPolicyAssert<S extends AbstractImageLookupPolicyAssert<S, A>, A extends ImageLookupPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageLookupPolicyAssert}</code> to make assertions on actual ImageLookupPolicy.
   * @param actual the ImageLookupPolicy we want to make assertions on.
   */
  protected AbstractImageLookupPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageLookupPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property local so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert local()  {
    // check that actual ImageLookupPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getLocal()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "local"));
  }


}
