package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageImportStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageImportStatusAssert<S extends AbstractImageImportStatusAssert<S, A>, A extends ImageImportStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageImportStatusAssert}</code> to make assertions on actual ImageImportStatus.
   * @param actual the ImageImportStatus we want to make assertions on.
   */
  protected AbstractImageImportStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public ImageAssert image()  {
    // check that actual ImageImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.StatusAssert status()  {
    // check that actual ImageImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.StatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property tag so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert tag()  {
    // check that actual ImageImportStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTag()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tag"));
  }


}
