package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageImportSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageImportSpecAssert<S extends AbstractImageImportSpecAssert<S, A>, A extends ImageImportSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageImportSpecAssert}</code> to make assertions on actual ImageImportSpec.
   * @param actual the ImageImportSpec we want to make assertions on.
   */
  protected AbstractImageImportSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property importPolicy so that assertions can be done on it
   */
  public TagImportPolicyAssert importPolicy()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TagImportPolicyAssert) assertThat(actual.getImportPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "importPolicy"));
  }


  /**
   * Navigates to the property includeManifest so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert includeManifest()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getIncludeManifest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "includeManifest"));
  }


  /**
   * Navigates to the property referencePolicy so that assertions can be done on it
   */
  public TagReferencePolicyAssert referencePolicy()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TagReferencePolicyAssert) assertThat(actual.getReferencePolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "referencePolicy"));
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert to()  {
    // check that actual ImageImportSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
  }


}
