package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Identity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIdentityAssert<S extends AbstractIdentityAssert<S, A>, A extends Identity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIdentityAssert}</code> to make assertions on actual Identity.
   * @param actual the Identity we want to make assertions on.
   */
  protected AbstractIdentityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property extra so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert extra()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getExtra()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extra"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property providerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert providerName()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProviderName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "providerName"));
  }


  /**
   * Navigates to the property providerUserName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert providerUserName()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProviderUserName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "providerUserName"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert user()  {
    // check that actual Identity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
