package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentTriggerPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentTriggerPolicyAssert<S extends AbstractDeploymentTriggerPolicyAssert<S, A>, A extends DeploymentTriggerPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentTriggerPolicyAssert}</code> to make assertions on actual DeploymentTriggerPolicy.
   * @param actual the DeploymentTriggerPolicy we want to make assertions on.
   */
  protected AbstractDeploymentTriggerPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property imageChangeParams so that assertions can be done on it
   */
  public DeploymentTriggerImageChangeParamsAssert imageChangeParams()  {
    // check that actual DeploymentTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeploymentTriggerImageChangeParamsAssert) assertThat(actual.getImageChangeParams()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageChangeParams"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual DeploymentTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
