package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentTriggerImageChangeParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentTriggerImageChangeParamsAssert<S extends AbstractDeploymentTriggerImageChangeParamsAssert<S, A>, A extends DeploymentTriggerImageChangeParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentTriggerImageChangeParamsAssert}</code> to make assertions on actual DeploymentTriggerImageChangeParams.
   * @param actual the DeploymentTriggerImageChangeParams we want to make assertions on.
   */
  protected AbstractDeploymentTriggerImageChangeParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentTriggerImageChangeParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property automatic so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert automatic()  {
    // check that actual DeploymentTriggerImageChangeParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAutomatic()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "automatic"));
  }


  /**
   * Navigates to the property containerNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> containerNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getContainerNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerNames"));
    return answer;
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual DeploymentTriggerImageChangeParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property lastTriggeredImage so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert lastTriggeredImage()  {
    // check that actual DeploymentTriggerImageChangeParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLastTriggeredImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTriggeredImage"));
  }


}
