package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentStrategyAssert<S extends AbstractDeploymentStrategyAssert<S, A>, A extends DeploymentStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentStrategyAssert}</code> to make assertions on actual DeploymentStrategy.
   * @param actual the DeploymentStrategy we want to make assertions on.
   */
  protected AbstractDeploymentStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Verifies that the actual DeploymentStrategy's activeDeadlineSeconds is equal to the given one.
   * @param activeDeadlineSeconds the given activeDeadlineSeconds to compare the actual DeploymentStrategy's activeDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategy's activeDeadlineSeconds is not equal to the given one.
   */
  public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualActiveDeadlineSeconds = actual.getActiveDeadlineSeconds();
    if (!Objects.areEqual(actualActiveDeadlineSeconds, activeDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, activeDeadlineSeconds, actualActiveDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property annotations so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert annotations()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "annotations"));
  }


  /**
   * Navigates to the property customParams so that assertions can be done on it
   */
  public CustomDeploymentStrategyParamsAssert customParams()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomDeploymentStrategyParamsAssert) assertThat(actual.getCustomParams()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customParams"));
  }


  /**
   * Navigates to the property labels so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert labels()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"));
  }


  /**
   * Navigates to the property recreateParams so that assertions can be done on it
   */
  public RecreateDeploymentStrategyParamsAssert recreateParams()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RecreateDeploymentStrategyParamsAssert) assertThat(actual.getRecreateParams()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "recreateParams"));
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ResourceRequirementsAssert resources()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ResourceRequirementsAssert) assertThat(actual.getResources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
  }


  /**
   * Navigates to the property rollingParams so that assertions can be done on it
   */
  public RollingDeploymentStrategyParamsAssert rollingParams()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollingDeploymentStrategyParamsAssert) assertThat(actual.getRollingParams()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollingParams"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual DeploymentStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
