package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentDetails} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentDetailsAssert<S extends AbstractDeploymentDetailsAssert<S, A>, A extends DeploymentDetails> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentDetailsAssert}</code> to make assertions on actual DeploymentDetails.
   * @param actual the DeploymentDetails we want to make assertions on.
   */
  protected AbstractDeploymentDetailsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property causes so that assertions can be done on it
   */
  public NavigationListAssert<DeploymentCause, DeploymentCauseAssert> causes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DeploymentCause, DeploymentCauseAssert> assertFactory = new AssertFactory<DeploymentCause, DeploymentCauseAssert>() {
      public DeploymentCauseAssert createAssert(DeploymentCause t) {
        return (DeploymentCauseAssert) assertThat(t);
      }
    };
    NavigationListAssert<DeploymentCause, DeploymentCauseAssert> answer = new NavigationListAssert<DeploymentCause, DeploymentCauseAssert>(actual.getCauses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "causes"));
    return answer;
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


}
