package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomDeploymentStrategyParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomDeploymentStrategyParamsAssert<S extends AbstractCustomDeploymentStrategyParamsAssert<S, A>, A extends CustomDeploymentStrategyParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomDeploymentStrategyParamsAssert}</code> to make assertions on actual CustomDeploymentStrategyParams.
   * @param actual the CustomDeploymentStrategyParams we want to make assertions on.
   */
  protected AbstractCustomDeploymentStrategyParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property command so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> command()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getCommand(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "command"));
    return answer;
  }


  /**
   * Navigates to the property environment so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> environment()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getEnvironment(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "environment"));
    return answer;
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual CustomDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


}
