package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ConfigMapBuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapBuildSourceAssert<S extends AbstractConfigMapBuildSourceAssert<S, A>, A extends ConfigMapBuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapBuildSourceAssert}</code> to make assertions on actual ConfigMapBuildSource.
   * @param actual the ConfigMapBuildSource we want to make assertions on.
   */
  protected AbstractConfigMapBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ConfigMapBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert configMap()  {
    // check that actual ConfigMapBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


  /**
   * Navigates to the property destinationDir so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert destinationDir()  {
    // check that actual ConfigMapBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDestinationDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "destinationDir"));
  }


}
