package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildTriggerCause} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildTriggerCauseAssert<S extends AbstractBuildTriggerCauseAssert<S, A>, A extends BuildTriggerCause> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildTriggerCauseAssert}</code> to make assertions on actual BuildTriggerCause.
   * @param actual the BuildTriggerCause we want to make assertions on.
   */
  protected AbstractBuildTriggerCauseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property bitbucketWebHook so that assertions can be done on it
   */
  public BitbucketWebHookCauseAssert bitbucketWebHook()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BitbucketWebHookCauseAssert) assertThat(actual.getBitbucketWebHook()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "bitbucketWebHook"));
  }


  /**
   * Navigates to the property genericWebHook so that assertions can be done on it
   */
  public GenericWebHookCauseAssert genericWebHook()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GenericWebHookCauseAssert) assertThat(actual.getGenericWebHook()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "genericWebHook"));
  }


  /**
   * Navigates to the property githubWebHook so that assertions can be done on it
   */
  public GitHubWebHookCauseAssert githubWebHook()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GitHubWebHookCauseAssert) assertThat(actual.getGithubWebHook()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "githubWebHook"));
  }


  /**
   * Navigates to the property gitlabWebHook so that assertions can be done on it
   */
  public GitLabWebHookCauseAssert gitlabWebHook()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GitLabWebHookCauseAssert) assertThat(actual.getGitlabWebHook()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gitlabWebHook"));
  }


  /**
   * Navigates to the property imageChangeBuild so that assertions can be done on it
   */
  public ImageChangeCauseAssert imageChangeBuild()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageChangeCauseAssert) assertThat(actual.getImageChangeBuild()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageChangeBuild"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual BuildTriggerCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


}
