package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildStatusOutputTo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStatusOutputToAssert<S extends AbstractBuildStatusOutputToAssert<S, A>, A extends BuildStatusOutputTo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStatusOutputToAssert}</code> to make assertions on actual BuildStatusOutputTo.
   * @param actual the BuildStatusOutputTo we want to make assertions on.
   */
  protected AbstractBuildStatusOutputToAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildStatusOutputTo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property imageDigest so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imageDigest()  {
    // check that actual BuildStatusOutputTo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImageDigest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageDigest"));
  }


}
