package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStatusAssert<S extends AbstractBuildStatusAssert<S, A>, A extends BuildStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStatusAssert}</code> to make assertions on actual BuildStatus.
   * @param actual the BuildStatus we want to make assertions on.
   */
  protected AbstractBuildStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cancelled so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert cancelled()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getCancelled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cancelled"));
  }


  /**
   * Navigates to the property completionTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert completionTimestamp()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCompletionTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "completionTimestamp"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<BuildCondition, BuildConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<BuildCondition, BuildConditionAssert> assertFactory = new AssertFactory<BuildCondition, BuildConditionAssert>() {
      public BuildConditionAssert createAssert(BuildCondition t) {
        return (BuildConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<BuildCondition, BuildConditionAssert> answer = new NavigationListAssert<BuildCondition, BuildConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property config so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert config()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "config"));
  }


  /**
   * Verifies that the actual BuildStatus's duration is equal to the given one.
   * @param duration the given duration to compare the actual BuildStatus's duration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatus's duration is not equal to the given one.
   */
  public S hasDuration(Long duration) {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting duration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDuration = actual.getDuration();
    if (!Objects.areEqual(actualDuration, duration)) {
      failWithMessage(assertjErrorMessage, actual, duration, actualDuration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property logSnippet so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert logSnippet()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLogSnippet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "logSnippet"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property output so that assertions can be done on it
   */
  public BuildStatusOutputAssert output()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildStatusOutputAssert) assertThat(actual.getOutput()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "output"));
  }


  /**
   * Navigates to the property outputDockerImageReference so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert outputDockerImageReference()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOutputDockerImageReference()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "outputDockerImageReference"));
  }


  /**
   * Navigates to the property phase so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert phase()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property stages so that assertions can be done on it
   */
  public NavigationListAssert<StageInfo, StageInfoAssert> stages()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<StageInfo, StageInfoAssert> assertFactory = new AssertFactory<StageInfo, StageInfoAssert>() {
      public StageInfoAssert createAssert(StageInfo t) {
        return (StageInfoAssert) assertThat(t);
      }
    };
    NavigationListAssert<StageInfo, StageInfoAssert> answer = new NavigationListAssert<StageInfo, StageInfoAssert>(actual.getStages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stages"));
    return answer;
  }


  /**
   * Navigates to the property startTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startTimestamp()  {
    // check that actual BuildStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTimestamp"));
  }


}
