package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSourceAssert<S extends AbstractBuildSourceAssert<S, A>, A extends BuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSourceAssert}</code> to make assertions on actual BuildSource.
   * @param actual the BuildSource we want to make assertions on.
   */
  protected AbstractBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property binary so that assertions can be done on it
   */
  public BinaryBuildSourceAssert binary()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BinaryBuildSourceAssert) assertThat(actual.getBinary()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "binary"));
  }


  /**
   * Navigates to the property configMaps so that assertions can be done on it
   */
  public NavigationListAssert<ConfigMapBuildSource, ConfigMapBuildSourceAssert> configMaps()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ConfigMapBuildSource, ConfigMapBuildSourceAssert> assertFactory = new AssertFactory<ConfigMapBuildSource, ConfigMapBuildSourceAssert>() {
      public ConfigMapBuildSourceAssert createAssert(ConfigMapBuildSource t) {
        return (ConfigMapBuildSourceAssert) assertThat(t);
      }
    };
    NavigationListAssert<ConfigMapBuildSource, ConfigMapBuildSourceAssert> answer = new NavigationListAssert<ConfigMapBuildSource, ConfigMapBuildSourceAssert>(actual.getConfigMaps(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMaps"));
    return answer;
  }


  /**
   * Navigates to the property contextDir so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert contextDir()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContextDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "contextDir"));
  }


  /**
   * Navigates to the property dockerfile so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerfile()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerfile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerfile"));
  }


  /**
   * Navigates to the property git so that assertions can be done on it
   */
  public GitBuildSourceAssert git()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GitBuildSourceAssert) assertThat(actual.getGit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "git"));
  }


  /**
   * Navigates to the property images so that assertions can be done on it
   */
  public NavigationListAssert<ImageSource, ImageSourceAssert> images()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageSource, ImageSourceAssert> assertFactory = new AssertFactory<ImageSource, ImageSourceAssert>() {
      public ImageSourceAssert createAssert(ImageSource t) {
        return (ImageSourceAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageSource, ImageSourceAssert> answer = new NavigationListAssert<ImageSource, ImageSourceAssert>(actual.getImages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "images"));
    return answer;
  }


  /**
   * Navigates to the property secrets so that assertions can be done on it
   */
  public NavigationListAssert<SecretBuildSource, SecretBuildSourceAssert> secrets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<SecretBuildSource, SecretBuildSourceAssert> assertFactory = new AssertFactory<SecretBuildSource, SecretBuildSourceAssert>() {
      public SecretBuildSourceAssert createAssert(SecretBuildSource t) {
        return (SecretBuildSourceAssert) assertThat(t);
      }
    };
    NavigationListAssert<SecretBuildSource, SecretBuildSourceAssert> answer = new NavigationListAssert<SecretBuildSource, SecretBuildSourceAssert>(actual.getSecrets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secrets"));
    return answer;
  }


  /**
   * Navigates to the property sourceSecret so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert sourceSecret()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getSourceSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sourceSecret"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
