package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildRequest} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildRequestAssert<S extends AbstractBuildRequestAssert<S, A>, A extends BuildRequest> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildRequestAssert}</code> to make assertions on actual BuildRequest.
   * @param actual the BuildRequest we want to make assertions on.
   */
  protected AbstractBuildRequestAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property binary so that assertions can be done on it
   */
  public BinaryBuildSourceAssert binary()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BinaryBuildSourceAssert) assertThat(actual.getBinary()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "binary"));
  }


  /**
   * Navigates to the property dockerStrategyOptions so that assertions can be done on it
   */
  public DockerStrategyOptionsAssert dockerStrategyOptions()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DockerStrategyOptionsAssert) assertThat(actual.getDockerStrategyOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerStrategyOptions"));
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Verifies that the actual BuildRequest's lastVersion is equal to the given one.
   * @param lastVersion the given lastVersion to compare the actual BuildRequest's lastVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's lastVersion is not equal to the given one.
   */
  public S hasLastVersion(Long lastVersion) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualLastVersion = actual.getLastVersion();
    if (!Objects.areEqual(actualLastVersion, lastVersion)) {
      failWithMessage(assertjErrorMessage, actual, lastVersion, actualLastVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property revision so that assertions can be done on it
   */
  public SourceRevisionAssert revision()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceRevisionAssert) assertThat(actual.getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"));
  }


  /**
   * Navigates to the property sourceStrategyOptions so that assertions can be done on it
   */
  public SourceStrategyOptionsAssert sourceStrategyOptions()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceStrategyOptionsAssert) assertThat(actual.getSourceStrategyOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sourceStrategyOptions"));
  }


  /**
   * Navigates to the property triggeredBy so that assertions can be done on it
   */
  public NavigationListAssert<BuildTriggerCause, BuildTriggerCauseAssert> triggeredBy()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<BuildTriggerCause, BuildTriggerCauseAssert> assertFactory = new AssertFactory<BuildTriggerCause, BuildTriggerCauseAssert>() {
      public BuildTriggerCauseAssert createAssert(BuildTriggerCause t) {
        return (BuildTriggerCauseAssert) assertThat(t);
      }
    };
    NavigationListAssert<BuildTriggerCause, BuildTriggerCauseAssert> answer = new NavigationListAssert<BuildTriggerCause, BuildTriggerCauseAssert>(actual.getTriggeredBy(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggeredBy"));
    return answer;
  }


  /**
   * Navigates to the property triggeredByImage so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert triggeredByImage()  {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getTriggeredByImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggeredByImage"));
  }


}
