package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildPostCommitSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildPostCommitSpecAssert<S extends AbstractBuildPostCommitSpecAssert<S, A>, A extends BuildPostCommitSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildPostCommitSpecAssert}</code> to make assertions on actual BuildPostCommitSpec.
   * @param actual the BuildPostCommitSpec we want to make assertions on.
   */
  protected AbstractBuildPostCommitSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildPostCommitSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property args so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> args()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getArgs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "args"));
    return answer;
  }


  /**
   * Navigates to the property command so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> command()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getCommand(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "command"));
    return answer;
  }


  /**
   * Navigates to the property script so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert script()  {
    // check that actual BuildPostCommitSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScript()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "script"));
  }


}
