package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link BinaryBuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBinaryBuildSourceAssert<S extends AbstractBinaryBuildSourceAssert<S, A>, A extends BinaryBuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBinaryBuildSourceAssert}</code> to make assertions on actual BinaryBuildSource.
   * @param actual the BinaryBuildSource we want to make assertions on.
   */
  protected AbstractBinaryBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BinaryBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property asFile so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert asFile()  {
    // check that actual BinaryBuildSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAsFile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "asFile"));
  }


}
