package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.APIGroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.APIGroupAssert assertThat(io.fabric8.kubernetes.api.model.APIGroup actual) {
    return new io.fabric8.kubernetes.api.model.APIGroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.APIGroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.APIGroupListAssert assertThat(io.fabric8.kubernetes.api.model.APIGroupList actual) {
    return new io.fabric8.kubernetes.api.model.APIGroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AffinityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AffinityAssert assertThat(io.fabric8.kubernetes.api.model.Affinity actual) {
    return new io.fabric8.kubernetes.api.model.AffinityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AttachedVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AttachedVolumeAssert assertThat(io.fabric8.kubernetes.api.model.AttachedVolume actual) {
    return new io.fabric8.kubernetes.api.model.AttachedVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthProviderConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthProviderConfigAssert assertThat(io.fabric8.kubernetes.api.model.AuthProviderConfig actual) {
    return new io.fabric8.kubernetes.api.model.AuthProviderConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AzureFileVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BindingAssert assertThat(io.fabric8.kubernetes.api.model.Binding actual) {
    return new io.fabric8.kubernetes.api.model.BindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.Capabilities actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CephFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CinderVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClientIPConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClientIPConfigAssert assertThat(io.fabric8.kubernetes.api.model.ClientIPConfig actual) {
    return new io.fabric8.kubernetes.api.model.ClientIPConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterAssert assertThat(io.fabric8.kubernetes.api.model.Cluster actual) {
    return new io.fabric8.kubernetes.api.model.ClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentConditionAssert assertThat(io.fabric8.kubernetes.api.model.ComponentCondition actual) {
    return new io.fabric8.kubernetes.api.model.ComponentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentStatusAssert assertThat(io.fabric8.kubernetes.api.model.ComponentStatus actual) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentStatusListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentStatusListAssert assertThat(io.fabric8.kubernetes.api.model.ComponentStatusList actual) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.Config actual) {
    return new io.fabric8.kubernetes.api.model.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMap actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapEnvSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapEnvSourceAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapEnvSource actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapEnvSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapKeySelector actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapListAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapList actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapProjectionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapProjectionAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapProjection actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapProjectionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerImageAssert assertThat(io.fabric8.kubernetes.api.model.ContainerImage actual) {
    return new io.fabric8.kubernetes.api.model.ContainerImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextAssert assertThat(io.fabric8.kubernetes.api.model.Context actual) {
    return new io.fabric8.kubernetes.api.model.ContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CreateOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CreateOptionsAssert assertThat(io.fabric8.kubernetes.api.model.CreateOptions actual) {
    return new io.fabric8.kubernetes.api.model.CreateOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.CrossVersionObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DaemonEndpointAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DaemonEndpointAssert assertThat(io.fabric8.kubernetes.api.model.DaemonEndpoint actual) {
    return new io.fabric8.kubernetes.api.model.DaemonEndpointAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DeleteOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DeleteOptionsAssert assertThat(io.fabric8.kubernetes.api.model.DeleteOptions actual) {
    return new io.fabric8.kubernetes.api.model.DeleteOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DownwardAPIProjectionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DownwardAPIProjectionAssert assertThat(io.fabric8.kubernetes.api.model.DownwardAPIProjection actual) {
    return new io.fabric8.kubernetes.api.model.DownwardAPIProjectionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert assertThat(io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile actual) {
    return new io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DurationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DurationAssert assertThat(io.fabric8.kubernetes.api.model.Duration actual) {
    return new io.fabric8.kubernetes.api.model.DurationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvFromSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvFromSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvFromSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvFromSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EphemeralContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EphemeralContainerAssert assertThat(io.fabric8.kubernetes.api.model.EphemeralContainer actual) {
    return new io.fabric8.kubernetes.api.model.EphemeralContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventAssert assertThat(io.fabric8.kubernetes.api.model.Event actual) {
    return new io.fabric8.kubernetes.api.model.EventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListAssert assertThat(io.fabric8.kubernetes.api.model.EventList actual) {
    return new io.fabric8.kubernetes.api.model.EventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSeriesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSeriesAssert assertThat(io.fabric8.kubernetes.api.model.EventSeries actual) {
    return new io.fabric8.kubernetes.api.model.EventSeriesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceAssert assertThat(io.fabric8.kubernetes.api.model.EventSource actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecConfigAssert assertThat(io.fabric8.kubernetes.api.model.ExecConfig actual) {
    return new io.fabric8.kubernetes.api.model.ExecConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecEnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecEnvVarAssert assertThat(io.fabric8.kubernetes.api.model.ExecEnvVar actual) {
    return new io.fabric8.kubernetes.api.model.ExecEnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExternalMetricSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExternalMetricSourceAssert assertThat(io.fabric8.kubernetes.api.model.ExternalMetricSource actual) {
    return new io.fabric8.kubernetes.api.model.ExternalMetricSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExternalMetricStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExternalMetricStatusAssert assertThat(io.fabric8.kubernetes.api.model.ExternalMetricStatus actual) {
    return new io.fabric8.kubernetes.api.model.ExternalMetricStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FCVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FCVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FCVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FCVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FieldsV1Assert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FieldsV1Assert assertThat(io.fabric8.kubernetes.api.model.FieldsV1 actual) {
    return new io.fabric8.kubernetes.api.model.FieldsV1Assert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FlexVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FlockerVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GetOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GetOptionsAssert assertThat(io.fabric8.kubernetes.api.model.GetOptions actual) {
    return new io.fabric8.kubernetes.api.model.GetOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryAssert assertThat(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery actual) {
    return new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GroupVersionKindAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GroupVersionKindAssert assertThat(io.fabric8.kubernetes.api.model.GroupVersionKind actual) {
    return new io.fabric8.kubernetes.api.model.GroupVersionKindAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GroupVersionResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GroupVersionResourceAssert assertThat(io.fabric8.kubernetes.api.model.GroupVersionResource actual) {
    return new io.fabric8.kubernetes.api.model.GroupVersionResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPHeaderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPHeaderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPHeader actual) {
    return new io.fabric8.kubernetes.api.model.HTTPHeaderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HasMetadataAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HasMetadataAssert assertThat(io.fabric8.kubernetes.api.model.HasMetadata actual) {
    return new io.fabric8.kubernetes.api.model.HasMetadataAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerAssert assertThat(io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler actual) {
    return new io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerConditionAssert assertThat(io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerCondition actual) {
    return new io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerListAssert assertThat(io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerList actual) {
    return new io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpecAssert assertThat(io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpec actual) {
    return new io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatusAssert assertThat(io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatus actual) {
    return new io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostAliasAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostAliasAssert assertThat(io.fabric8.kubernetes.api.model.HostAlias actual) {
    return new io.fabric8.kubernetes.api.model.HostAliasAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KeyToPathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KeyToPathAssert assertThat(io.fabric8.kubernetes.api.model.KeyToPath actual) {
    return new io.fabric8.kubernetes.api.model.KeyToPathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResource actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResourceList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LabelSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LabelSelectorAssert assertThat(io.fabric8.kubernetes.api.model.LabelSelector actual) {
    return new io.fabric8.kubernetes.api.model.LabelSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert assertThat(io.fabric8.kubernetes.api.model.LabelSelectorRequirement actual) {
    return new io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeAssert assertThat(io.fabric8.kubernetes.api.model.LimitRange actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeItemAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeItemAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeItem actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeItemAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeListAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeList actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeSpecAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeSpec actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListOptionsAssert assertThat(io.fabric8.kubernetes.api.model.ListOptions actual) {
    return new io.fabric8.kubernetes.api.model.ListOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.LocalVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.LocalVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ManagedFieldsEntryAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ManagedFieldsEntryAssert assertThat(io.fabric8.kubernetes.api.model.ManagedFieldsEntry actual) {
    return new io.fabric8.kubernetes.api.model.ManagedFieldsEntryAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetricIdentifierAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetricIdentifierAssert assertThat(io.fabric8.kubernetes.api.model.MetricIdentifier actual) {
    return new io.fabric8.kubernetes.api.model.MetricIdentifierAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetricSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetricSpecAssert assertThat(io.fabric8.kubernetes.api.model.MetricSpec actual) {
    return new io.fabric8.kubernetes.api.model.MetricSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetricStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetricStatusAssert assertThat(io.fabric8.kubernetes.api.model.MetricStatus actual) {
    return new io.fabric8.kubernetes.api.model.MetricStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetricTargetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetricTargetAssert assertThat(io.fabric8.kubernetes.api.model.MetricTarget actual) {
    return new io.fabric8.kubernetes.api.model.MetricTargetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetricValueStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetricValueStatusAssert assertThat(io.fabric8.kubernetes.api.model.MetricValueStatus actual) {
    return new io.fabric8.kubernetes.api.model.MetricValueStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MicroTimeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MicroTimeAssert assertThat(io.fabric8.kubernetes.api.model.MicroTime actual) {
    return new io.fabric8.kubernetes.api.model.MicroTimeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.NamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextAssert assertThat(io.fabric8.kubernetes.api.model.NamedContext actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceAssert assertThat(io.fabric8.kubernetes.api.model.Namespace actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceConditionAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceCondition actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAssert assertThat(io.fabric8.kubernetes.api.model.Node actual) {
    return new io.fabric8.kubernetes.api.model.NodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAffinityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAffinityAssert assertThat(io.fabric8.kubernetes.api.model.NodeAffinity actual) {
    return new io.fabric8.kubernetes.api.model.NodeAffinityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConfigSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConfigSourceAssert assertThat(io.fabric8.kubernetes.api.model.NodeConfigSource actual) {
    return new io.fabric8.kubernetes.api.model.NodeConfigSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConfigStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeConfigStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListAssert assertThat(io.fabric8.kubernetes.api.model.NodeList actual) {
    return new io.fabric8.kubernetes.api.model.NodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSelectorAssert assertThat(io.fabric8.kubernetes.api.model.NodeSelector actual) {
    return new io.fabric8.kubernetes.api.model.NodeSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSelectorRequirementAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSelectorRequirementAssert assertThat(io.fabric8.kubernetes.api.model.NodeSelectorRequirement actual) {
    return new io.fabric8.kubernetes.api.model.NodeSelectorRequirementAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSelectorTermAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSelectorTermAssert assertThat(io.fabric8.kubernetes.api.model.NodeSelectorTerm actual) {
    return new io.fabric8.kubernetes.api.model.NodeSelectorTermAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetricSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetricSourceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetricSource actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetricSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetricStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetricStatusAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetricStatus actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetricStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.OwnerReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.OwnerReferenceAssert assertThat(io.fabric8.kubernetes.api.model.OwnerReference actual) {
    return new io.fabric8.kubernetes.api.model.OwnerReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PatchAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PatchAssert assertThat(io.fabric8.kubernetes.api.model.Patch actual) {
    return new io.fabric8.kubernetes.api.model.PatchAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PatchOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PatchOptionsAssert assertThat(io.fabric8.kubernetes.api.model.PatchOptions actual) {
    return new io.fabric8.kubernetes.api.model.PatchOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAffinityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAffinityAssert assertThat(io.fabric8.kubernetes.api.model.PodAffinity actual) {
    return new io.fabric8.kubernetes.api.model.PodAffinityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAffinityTermAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAffinityTermAssert assertThat(io.fabric8.kubernetes.api.model.PodAffinityTerm actual) {
    return new io.fabric8.kubernetes.api.model.PodAffinityTermAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAntiAffinityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAntiAffinityAssert assertThat(io.fabric8.kubernetes.api.model.PodAntiAffinity actual) {
    return new io.fabric8.kubernetes.api.model.PodAntiAffinityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionAssert assertThat(io.fabric8.kubernetes.api.model.PodCondition actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodDNSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodDNSConfigAssert assertThat(io.fabric8.kubernetes.api.model.PodDNSConfig actual) {
    return new io.fabric8.kubernetes.api.model.PodDNSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodDNSConfigOptionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodDNSConfigOptionAssert assertThat(io.fabric8.kubernetes.api.model.PodDNSConfigOption actual) {
    return new io.fabric8.kubernetes.api.model.PodDNSConfigOptionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodIPAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodIPAssert assertThat(io.fabric8.kubernetes.api.model.PodIP actual) {
    return new io.fabric8.kubernetes.api.model.PodIPAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodReadinessGateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodReadinessGateAssert assertThat(io.fabric8.kubernetes.api.model.PodReadinessGate actual) {
    return new io.fabric8.kubernetes.api.model.PodReadinessGateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.PodSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.PodSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateListAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateList actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodsMetricSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodsMetricSourceAssert assertThat(io.fabric8.kubernetes.api.model.PodsMetricSource actual) {
    return new io.fabric8.kubernetes.api.model.PodsMetricSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodsMetricStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodsMetricStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodsMetricStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodsMetricStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortworxVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortworxVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PortworxVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PortworxVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreconditionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreconditionsAssert assertThat(io.fabric8.kubernetes.api.model.Preconditions actual) {
    return new io.fabric8.kubernetes.api.model.PreconditionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesAssert assertThat(io.fabric8.kubernetes.api.model.Preferences actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferredSchedulingTermAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferredSchedulingTermAssert assertThat(io.fabric8.kubernetes.api.model.PreferredSchedulingTerm actual) {
    return new io.fabric8.kubernetes.api.model.PreferredSchedulingTermAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeAssert assertThat(io.fabric8.kubernetes.api.model.Probe actual) {
    return new io.fabric8.kubernetes.api.model.ProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProjectedVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProjectedVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ProjectedVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.QuobyteVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerCondition actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ResourceFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceMetricSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceMetricSourceAssert assertThat(io.fabric8.kubernetes.api.model.ResourceMetricSource actual) {
    return new io.fabric8.kubernetes.api.model.ResourceMetricSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceMetricStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceMetricStatusAssert assertThat(io.fabric8.kubernetes.api.model.ResourceMetricStatus actual) {
    return new io.fabric8.kubernetes.api.model.ResourceMetricStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RootPathsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RootPathsAssert assertThat(io.fabric8.kubernetes.api.model.RootPaths actual) {
    return new io.fabric8.kubernetes.api.model.RootPathsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ScopeSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ScopeSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ScopeSelector actual) {
    return new io.fabric8.kubernetes.api.model.ScopeSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirementAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirementAssert assertThat(io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirement actual) {
    return new io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirementAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretAssert assertThat(io.fabric8.kubernetes.api.model.Secret actual) {
    return new io.fabric8.kubernetes.api.model.SecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretEnvSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretEnvSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretEnvSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretEnvSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretKeySelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretKeySelectorAssert assertThat(io.fabric8.kubernetes.api.model.SecretKeySelector actual) {
    return new io.fabric8.kubernetes.api.model.SecretKeySelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListAssert assertThat(io.fabric8.kubernetes.api.model.SecretList actual) {
    return new io.fabric8.kubernetes.api.model.SecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretProjectionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretProjectionAssert assertThat(io.fabric8.kubernetes.api.model.SecretProjection actual) {
    return new io.fabric8.kubernetes.api.model.SecretProjectionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretReferenceAssert assertThat(io.fabric8.kubernetes.api.model.SecretReference actual) {
    return new io.fabric8.kubernetes.api.model.SecretReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRAssert assertThat(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR actual) {
    return new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortAssert assertThat(io.fabric8.kubernetes.api.model.ServicePort actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SessionAffinityConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SessionAffinityConfigAssert assertThat(io.fabric8.kubernetes.api.model.SessionAffinityConfig actual) {
    return new io.fabric8.kubernetes.api.model.SessionAffinityConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusAssert assertThat(io.fabric8.kubernetes.api.model.Status actual) {
    return new io.fabric8.kubernetes.api.model.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StorageOSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StorageOSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.StorageOSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.StorageOSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SysctlAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SysctlAssert assertThat(io.fabric8.kubernetes.api.model.Sysctl actual) {
    return new io.fabric8.kubernetes.api.model.SysctlAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TaintAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TaintAssert assertThat(io.fabric8.kubernetes.api.model.Taint actual) {
    return new io.fabric8.kubernetes.api.model.TaintAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TolerationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TolerationAssert assertThat(io.fabric8.kubernetes.api.model.Toleration actual) {
    return new io.fabric8.kubernetes.api.model.TolerationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirementAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirementAssert assertThat(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement actual) {
    return new io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirementAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TopologySelectorTermAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TopologySelectorTermAssert assertThat(io.fabric8.kubernetes.api.model.TopologySelectorTerm actual) {
    return new io.fabric8.kubernetes.api.model.TopologySelectorTermAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TopologySpreadConstraintAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TopologySpreadConstraintAssert assertThat(io.fabric8.kubernetes.api.model.TopologySpreadConstraint actual) {
    return new io.fabric8.kubernetes.api.model.TopologySpreadConstraintAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TypeMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TypeMetaAssert assertThat(io.fabric8.kubernetes.api.model.TypeMeta actual) {
    return new io.fabric8.kubernetes.api.model.TypeMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.TypedLocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.UpdateOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.UpdateOptionsAssert assertThat(io.fabric8.kubernetes.api.model.UpdateOptions actual) {
    return new io.fabric8.kubernetes.api.model.UpdateOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeDeviceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeDeviceAssert assertThat(io.fabric8.kubernetes.api.model.VolumeDevice actual) {
    return new io.fabric8.kubernetes.api.model.VolumeDeviceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeNodeAffinityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeNodeAffinityAssert assertThat(io.fabric8.kubernetes.api.model.VolumeNodeAffinity actual) {
    return new io.fabric8.kubernetes.api.model.VolumeNodeAffinityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeProjectionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeProjectionAssert assertThat(io.fabric8.kubernetes.api.model.VolumeProjection actual) {
    return new io.fabric8.kubernetes.api.model.VolumeProjectionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventAssert assertThat(io.fabric8.kubernetes.api.model.WatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WeightedPodAffinityTermAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WeightedPodAffinityTermAssert assertThat(io.fabric8.kubernetes.api.model.WeightedPodAffinityTerm actual) {
    return new io.fabric8.kubernetes.api.model.WeightedPodAffinityTermAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsAssert assertThat(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions actual) {
    return new io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admission.AdmissionRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admission.AdmissionRequestAssert assertThat(io.fabric8.kubernetes.api.model.admission.AdmissionRequest actual) {
    return new io.fabric8.kubernetes.api.model.admission.AdmissionRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admission.AdmissionResponseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admission.AdmissionResponseAssert assertThat(io.fabric8.kubernetes.api.model.admission.AdmissionResponse actual) {
    return new io.fabric8.kubernetes.api.model.admission.AdmissionResponseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admission.AdmissionReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admission.AdmissionReviewAssert assertThat(io.fabric8.kubernetes.api.model.admission.AdmissionReview actual) {
    return new io.fabric8.kubernetes.api.model.admission.AdmissionReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhook actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfiguration actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationListAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationList actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.MutatingWebhookConfigurationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.RuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.RuleAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.Rule actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.RuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperationsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperationsAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperations actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.RuleWithOperationsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.ServiceReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.ServiceReferenceAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.ServiceReference actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.ServiceReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhook actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfiguration actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationListAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationList actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.ValidatingWebhookConfigurationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.admissionregistration.WebhookClientConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.admissionregistration.WebhookClientConfigAssert assertThat(io.fabric8.kubernetes.api.model.admissionregistration.WebhookClientConfig actual) {
    return new io.fabric8.kubernetes.api.model.admissionregistration.WebhookClientConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceColumnDefinitionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceColumnDefinitionAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceColumnDefinition actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceColumnDefinitionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceConversionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceConversionAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceConversion actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceConversionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionConditionAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionCondition actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionListAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionList actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNamesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNamesAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNames actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionNamesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpec actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatusAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatus actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersion actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScaleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScaleAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScale actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceScaleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceStatusAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceStatus actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourcesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourcesAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresources actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceSubresourcesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.CustomResourceValidationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.CustomResourceValidationAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.CustomResourceValidation actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.CustomResourceValidationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.ExternalDocumentationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.ExternalDocumentationAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.ExternalDocumentation actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.ExternalDocumentationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.JSONAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.JSONAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.JSON actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.JSONAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaProps actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrArrayAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrArrayAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrArray actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrArrayAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrBoolAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrBoolAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrBool actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrBoolAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArrayAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArrayAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArray actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.JSONSchemaPropsOrStringArrayAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.ServiceReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.ServiceReferenceAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.ServiceReference actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.ServiceReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apiextensions.WebhookClientConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apiextensions.WebhookClientConfigAssert assertThat(io.fabric8.kubernetes.api.model.apiextensions.WebhookClientConfig actual) {
    return new io.fabric8.kubernetes.api.model.apiextensions.WebhookClientConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ControllerRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ControllerRevisionAssert assertThat(io.fabric8.kubernetes.api.model.apps.ControllerRevision actual) {
    return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ControllerRevisionListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ControllerRevisionListAssert assertThat(io.fabric8.kubernetes.api.model.apps.ControllerRevisionList actual) {
    return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSet actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetConditionAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSetCondition actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetListAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSetList actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyAssert assertThat(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy actual) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentAssert assertThat(io.fabric8.kubernetes.api.model.apps.Deployment actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentConditionAssert assertThat(io.fabric8.kubernetes.api.model.apps.DeploymentCondition actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentListAssert assertThat(io.fabric8.kubernetes.api.model.apps.DeploymentList actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentSpecAssert assertThat(io.fabric8.kubernetes.api.model.apps.DeploymentSpec actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentStatusAssert assertThat(io.fabric8.kubernetes.api.model.apps.DeploymentStatus actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.DeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.DeploymentStrategyAssert assertThat(io.fabric8.kubernetes.api.model.apps.DeploymentStrategy actual) {
    return new io.fabric8.kubernetes.api.model.apps.DeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ReplicaSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ReplicaSetAssert assertThat(io.fabric8.kubernetes.api.model.apps.ReplicaSet actual) {
    return new io.fabric8.kubernetes.api.model.apps.ReplicaSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ReplicaSetConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ReplicaSetConditionAssert assertThat(io.fabric8.kubernetes.api.model.apps.ReplicaSetCondition actual) {
    return new io.fabric8.kubernetes.api.model.apps.ReplicaSetConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ReplicaSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ReplicaSetListAssert assertThat(io.fabric8.kubernetes.api.model.apps.ReplicaSetList actual) {
    return new io.fabric8.kubernetes.api.model.apps.ReplicaSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.RollingUpdateDaemonSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.RollingUpdateDaemonSetAssert assertThat(io.fabric8.kubernetes.api.model.apps.RollingUpdateDaemonSet actual) {
    return new io.fabric8.kubernetes.api.model.apps.RollingUpdateDaemonSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.RollingUpdateDeploymentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.RollingUpdateDeploymentAssert assertThat(io.fabric8.kubernetes.api.model.apps.RollingUpdateDeployment actual) {
    return new io.fabric8.kubernetes.api.model.apps.RollingUpdateDeploymentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.RollingUpdateStatefulSetStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.RollingUpdateStatefulSetStrategyAssert assertThat(io.fabric8.kubernetes.api.model.apps.RollingUpdateStatefulSetStrategy actual) {
    return new io.fabric8.kubernetes.api.model.apps.RollingUpdateStatefulSetStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSet actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetConditionAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetListAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSetList actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyAssert assertThat(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy actual) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authentication.TokenReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authentication.TokenReviewAssert assertThat(io.fabric8.kubernetes.api.model.authentication.TokenReview actual) {
    return new io.fabric8.kubernetes.api.model.authentication.TokenReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecAssert assertThat(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec actual) {
    return new io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusAssert assertThat(io.fabric8.kubernetes.api.model.authentication.TokenReviewStatus actual) {
    return new io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authentication.UserInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authentication.UserInfoAssert assertThat(io.fabric8.kubernetes.api.model.authentication.UserInfo actual) {
    return new io.fabric8.kubernetes.api.model.authentication.UserInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReviewAssert assertThat(io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReview actual) {
    return new io.fabric8.kubernetes.api.model.authorization.LocalSubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.NonResourceAttributesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.NonResourceAttributesAssert assertThat(io.fabric8.kubernetes.api.model.authorization.NonResourceAttributes actual) {
    return new io.fabric8.kubernetes.api.model.authorization.NonResourceAttributesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.NonResourceRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.NonResourceRuleAssert assertThat(io.fabric8.kubernetes.api.model.authorization.NonResourceRule actual) {
    return new io.fabric8.kubernetes.api.model.authorization.NonResourceRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.ResourceAttributesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.ResourceAttributesAssert assertThat(io.fabric8.kubernetes.api.model.authorization.ResourceAttributes actual) {
    return new io.fabric8.kubernetes.api.model.authorization.ResourceAttributesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.ResourceRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.ResourceRuleAssert assertThat(io.fabric8.kubernetes.api.model.authorization.ResourceRule actual) {
    return new io.fabric8.kubernetes.api.model.authorization.ResourceRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReview actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewSpecAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewSpec actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReview actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewSpecAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewSpec actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReviewSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SubjectAccessReview actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewSpecAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewSpec actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewStatusAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewStatus actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SubjectAccessReviewStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.authorization.SubjectRulesReviewStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.authorization.SubjectRulesReviewStatusAssert assertThat(io.fabric8.kubernetes.api.model.authorization.SubjectRulesReviewStatus actual) {
    return new io.fabric8.kubernetes.api.model.authorization.SubjectRulesReviewStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.CronJobAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.CronJobAssert assertThat(io.fabric8.kubernetes.api.model.batch.CronJob actual) {
    return new io.fabric8.kubernetes.api.model.batch.CronJobAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.CronJobListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.CronJobListAssert assertThat(io.fabric8.kubernetes.api.model.batch.CronJobList actual) {
    return new io.fabric8.kubernetes.api.model.batch.CronJobListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.CronJobSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.CronJobSpecAssert assertThat(io.fabric8.kubernetes.api.model.batch.CronJobSpec actual) {
    return new io.fabric8.kubernetes.api.model.batch.CronJobSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.CronJobStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.CronJobStatusAssert assertThat(io.fabric8.kubernetes.api.model.batch.CronJobStatus actual) {
    return new io.fabric8.kubernetes.api.model.batch.CronJobStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobAssert assertThat(io.fabric8.kubernetes.api.model.batch.Job actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobConditionAssert assertThat(io.fabric8.kubernetes.api.model.batch.JobCondition actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobListAssert assertThat(io.fabric8.kubernetes.api.model.batch.JobList actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobSpecAssert assertThat(io.fabric8.kubernetes.api.model.batch.JobSpec actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobStatusAssert assertThat(io.fabric8.kubernetes.api.model.batch.JobStatus actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.batch.JobTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.batch.JobTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.batch.JobTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.batch.JobTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestAssert assertThat(io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequest actual) {
    return new io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestConditionAssert assertThat(io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestCondition actual) {
    return new io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestListAssert assertThat(io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestList actual) {
    return new io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpecAssert assertThat(io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpec actual) {
    return new io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatusAssert assertThat(io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatus actual) {
    return new io.fabric8.kubernetes.api.model.certificates.CertificateSigningRequestStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.coordination.v1.LeaseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.coordination.v1.LeaseAssert assertThat(io.fabric8.kubernetes.api.model.coordination.v1.Lease actual) {
    return new io.fabric8.kubernetes.api.model.coordination.v1.LeaseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.coordination.v1.LeaseListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.coordination.v1.LeaseListAssert assertThat(io.fabric8.kubernetes.api.model.coordination.v1.LeaseList actual) {
    return new io.fabric8.kubernetes.api.model.coordination.v1.LeaseListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecAssert assertThat(io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec actual) {
    return new io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.discovery.DiscoveryEndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.discovery.EndpointAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.discovery.EndpointAssert assertThat(io.fabric8.kubernetes.api.model.discovery.Endpoint actual) {
    return new io.fabric8.kubernetes.api.model.discovery.EndpointAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.discovery.EndpointConditionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.discovery.EndpointConditionsAssert assertThat(io.fabric8.kubernetes.api.model.discovery.EndpointConditions actual) {
    return new io.fabric8.kubernetes.api.model.discovery.EndpointConditionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.discovery.EndpointSliceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.discovery.EndpointSliceAssert assertThat(io.fabric8.kubernetes.api.model.discovery.EndpointSlice actual) {
    return new io.fabric8.kubernetes.api.model.discovery.EndpointSliceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.discovery.EndpointSliceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.discovery.EndpointSliceListAssert assertThat(io.fabric8.kubernetes.api.model.discovery.EndpointSliceList actual) {
    return new io.fabric8.kubernetes.api.model.discovery.EndpointSliceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.events.EventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.events.EventAssert assertThat(io.fabric8.kubernetes.api.model.events.Event actual) {
    return new io.fabric8.kubernetes.api.model.events.EventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.events.EventSeriesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.events.EventSeriesAssert assertThat(io.fabric8.kubernetes.api.model.events.EventSeries actual) {
    return new io.fabric8.kubernetes.api.model.events.EventSeriesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentRollback actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressAssert assertThat(io.fabric8.kubernetes.api.model.extensions.Ingress actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressBackend actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressRule actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressTLS actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert assertThat(io.fabric8.kubernetes.api.model.extensions.RollbackConfig actual) {
    return new io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsAssert assertThat(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics actual) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsAssert assertThat(io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics actual) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsListAssert assertThat(io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsList actual) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsAssert assertThat(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics actual) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListAssert assertThat(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList actual) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.IPBlockAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.IPBlockAssert assertThat(io.fabric8.kubernetes.api.model.networking.IPBlock actual) {
    return new io.fabric8.kubernetes.api.model.networking.IPBlockAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicy actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRule actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRule actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyListAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicyList actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeer actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicyPort actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.networking.NetworkPolicySpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.networking.NetworkPolicySpecAssert assertThat(io.fabric8.kubernetes.api.model.networking.NetworkPolicySpec actual) {
    return new io.fabric8.kubernetes.api.model.networking.NetworkPolicySpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.AllowedCSIDriverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.AllowedCSIDriverAssert assertThat(io.fabric8.kubernetes.api.model.policy.AllowedCSIDriver actual) {
    return new io.fabric8.kubernetes.api.model.policy.AllowedCSIDriverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.AllowedFlexVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.AllowedFlexVolumeAssert assertThat(io.fabric8.kubernetes.api.model.policy.AllowedFlexVolume actual) {
    return new io.fabric8.kubernetes.api.model.policy.AllowedFlexVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.AllowedHostPathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.AllowedHostPathAssert assertThat(io.fabric8.kubernetes.api.model.policy.AllowedHostPath actual) {
    return new io.fabric8.kubernetes.api.model.policy.AllowedHostPathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.FSGroupStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.HostPortRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.HostPortRangeAssert assertThat(io.fabric8.kubernetes.api.model.policy.HostPortRange actual) {
    return new io.fabric8.kubernetes.api.model.policy.HostPortRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.IDRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.IDRangeAssert assertThat(io.fabric8.kubernetes.api.model.policy.IDRange actual) {
    return new io.fabric8.kubernetes.api.model.policy.IDRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.KubernetesRunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodDisruptionBudget actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetListAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetList actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpecAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpec actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetStatusAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetStatus actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodSecurityPolicy actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyListAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyList actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodSecurityPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecAssert assertThat(io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpec actual) {
    return new io.fabric8.kubernetes.api.model.policy.PodSecurityPolicySpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.RunAsGroupStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.RuntimeClassStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.SELinuxStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.policy.SupplementalGroupsStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.AggregationRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.AggregationRuleAssert assertThat(io.fabric8.kubernetes.api.model.rbac.AggregationRule actual) {
    return new io.fabric8.kubernetes.api.model.rbac.AggregationRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.ClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.ClusterRoleAssert assertThat(io.fabric8.kubernetes.api.model.rbac.ClusterRole actual) {
    return new io.fabric8.kubernetes.api.model.rbac.ClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingAssert assertThat(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding actual) {
    return new io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListAssert assertThat(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList actual) {
    return new io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.ClusterRoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.ClusterRoleListAssert assertThat(io.fabric8.kubernetes.api.model.rbac.ClusterRoleList actual) {
    return new io.fabric8.kubernetes.api.model.rbac.ClusterRoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.PolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.PolicyRuleAssert assertThat(io.fabric8.kubernetes.api.model.rbac.PolicyRule actual) {
    return new io.fabric8.kubernetes.api.model.rbac.PolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.RoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.RoleAssert assertThat(io.fabric8.kubernetes.api.model.rbac.Role actual) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.RoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.RoleBindingAssert assertThat(io.fabric8.kubernetes.api.model.rbac.RoleBinding actual) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.RoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.RoleBindingListAssert assertThat(io.fabric8.kubernetes.api.model.rbac.RoleBindingList actual) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.RoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.RoleListAssert assertThat(io.fabric8.kubernetes.api.model.rbac.RoleList actual) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.RoleRefAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.RoleRefAssert assertThat(io.fabric8.kubernetes.api.model.rbac.RoleRef actual) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleRefAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.rbac.SubjectAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.rbac.SubjectAssert assertThat(io.fabric8.kubernetes.api.model.rbac.Subject actual) {
    return new io.fabric8.kubernetes.api.model.rbac.SubjectAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert assertThat(io.fabric8.kubernetes.api.model.runtime.RawExtension actual) {
    return new io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.scheduling.PriorityClassAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.scheduling.PriorityClassAssert assertThat(io.fabric8.kubernetes.api.model.scheduling.PriorityClass actual) {
    return new io.fabric8.kubernetes.api.model.scheduling.PriorityClassAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.scheduling.PriorityClassListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.scheduling.PriorityClassListAssert assertThat(io.fabric8.kubernetes.api.model.scheduling.PriorityClassList actual) {
    return new io.fabric8.kubernetes.api.model.scheduling.PriorityClassListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.settings.PodPresetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.settings.PodPresetAssert assertThat(io.fabric8.kubernetes.api.model.settings.PodPreset actual) {
    return new io.fabric8.kubernetes.api.model.settings.PodPresetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.settings.PodPresetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.settings.PodPresetListAssert assertThat(io.fabric8.kubernetes.api.model.settings.PodPresetList actual) {
    return new io.fabric8.kubernetes.api.model.settings.PodPresetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.settings.PodPresetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.settings.PodPresetSpecAssert assertThat(io.fabric8.kubernetes.api.model.settings.PodPresetSpec actual) {
    return new io.fabric8.kubernetes.api.model.settings.PodPresetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.StorageClassAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.StorageClassAssert assertThat(io.fabric8.kubernetes.api.model.storage.StorageClass actual) {
    return new io.fabric8.kubernetes.api.model.storage.StorageClassAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.StorageClassListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.StorageClassListAssert assertThat(io.fabric8.kubernetes.api.model.storage.StorageClassList actual) {
    return new io.fabric8.kubernetes.api.model.storage.StorageClassListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeAttachmentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeAttachmentAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeAttachment actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeAttachmentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeAttachmentListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeAttachmentListAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentList actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeAttachmentListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpecAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpec actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatus actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.VolumeErrorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.VolumeErrorAssert assertThat(io.fabric8.kubernetes.api.model.storage.VolumeError actual) {
    return new io.fabric8.kubernetes.api.model.storage.VolumeErrorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverListAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverList actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpec actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeListAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeList actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesAssert assertThat(io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResources actual) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.v1.ScaleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.v1.ScaleAssert assertThat(io.fabric8.kubernetes.api.model.v1.Scale actual) {
    return new io.fabric8.kubernetes.api.model.v1.ScaleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.v1.ScaleSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.v1.ScaleSpecAssert assertThat(io.fabric8.kubernetes.api.model.v1.ScaleSpec actual) {
    return new io.fabric8.kubernetes.api.model.v1.ScaleSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.v1.ScaleStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.v1.ScaleStatusAssert assertThat(io.fabric8.kubernetes.api.model.v1.ScaleStatus actual) {
    return new io.fabric8.kubernetes.api.model.v1.ScaleStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.version.InfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.version.InfoAssert assertThat(io.fabric8.kubernetes.api.model.version.Info actual) {
    return new io.fabric8.kubernetes.api.model.version.InfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.AllowedFlexVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.AllowedFlexVolumeAssert assertThat(io.fabric8.openshift.api.model.AllowedFlexVolume actual) {
    return new io.fabric8.openshift.api.model.AllowedFlexVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BinaryBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BinaryBuildSourceAssert assertThat(io.fabric8.openshift.api.model.BinaryBuildSource actual) {
    return new io.fabric8.openshift.api.model.BinaryBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BitbucketWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BitbucketWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.BitbucketWebHookCause actual) {
    return new io.fabric8.openshift.api.model.BitbucketWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildAssert assertThat(io.fabric8.openshift.api.model.Build actual) {
    return new io.fabric8.openshift.api.model.BuildAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConditionAssert assertThat(io.fabric8.openshift.api.model.BuildCondition actual) {
    return new io.fabric8.openshift.api.model.BuildConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigAssert assertThat(io.fabric8.openshift.api.model.BuildConfig actual) {
    return new io.fabric8.openshift.api.model.BuildConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigListAssert assertThat(io.fabric8.openshift.api.model.BuildConfigList actual) {
    return new io.fabric8.openshift.api.model.BuildConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigSpecAssert assertThat(io.fabric8.openshift.api.model.BuildConfigSpec actual) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigStatusAssert assertThat(io.fabric8.openshift.api.model.BuildConfigStatus actual) {
    return new io.fabric8.openshift.api.model.BuildConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildListAssert assertThat(io.fabric8.openshift.api.model.BuildList actual) {
    return new io.fabric8.openshift.api.model.BuildListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildOutputAssert assertThat(io.fabric8.openshift.api.model.BuildOutput actual) {
    return new io.fabric8.openshift.api.model.BuildOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildPostCommitSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildPostCommitSpecAssert assertThat(io.fabric8.openshift.api.model.BuildPostCommitSpec actual) {
    return new io.fabric8.openshift.api.model.BuildPostCommitSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildRequestAssert assertThat(io.fabric8.openshift.api.model.BuildRequest actual) {
    return new io.fabric8.openshift.api.model.BuildRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSourceAssert assertThat(io.fabric8.openshift.api.model.BuildSource actual) {
    return new io.fabric8.openshift.api.model.BuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSpecAssert assertThat(io.fabric8.openshift.api.model.BuildSpec actual) {
    return new io.fabric8.openshift.api.model.BuildSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusAssert assertThat(io.fabric8.openshift.api.model.BuildStatus actual) {
    return new io.fabric8.openshift.api.model.BuildStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusOutputAssert assertThat(io.fabric8.openshift.api.model.BuildStatusOutput actual) {
    return new io.fabric8.openshift.api.model.BuildStatusOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusOutputToAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusOutputToAssert assertThat(io.fabric8.openshift.api.model.BuildStatusOutputTo actual) {
    return new io.fabric8.openshift.api.model.BuildStatusOutputToAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStrategyAssert assertThat(io.fabric8.openshift.api.model.BuildStrategy actual) {
    return new io.fabric8.openshift.api.model.BuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerCauseAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerCause actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ConfigMapBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ConfigMapBuildSourceAssert assertThat(io.fabric8.openshift.api.model.ConfigMapBuildSource actual) {
    return new io.fabric8.openshift.api.model.ConfigMapBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.CustomBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.CustomBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.CustomDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseAssert assertThat(io.fabric8.openshift.api.model.DeploymentCause actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseImageTrigger actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConditionAssert assertThat(io.fabric8.openshift.api.model.DeploymentCondition actual) {
    return new io.fabric8.openshift.api.model.DeploymentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfig actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigListAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigList actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigSpecAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigSpec actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigStatusAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigStatus actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentDetailsAssert assertThat(io.fabric8.openshift.api.model.DeploymentDetails actual) {
    return new io.fabric8.openshift.api.model.DeploymentDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentStrategyAssert assertThat(io.fabric8.openshift.api.model.DeploymentStrategy actual) {
    return new io.fabric8.openshift.api.model.DeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DockerBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.DockerStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.DockerStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ExecNewPodHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ExecNewPodHookAssert assertThat(io.fabric8.openshift.api.model.ExecNewPodHook actual) {
    return new io.fabric8.openshift.api.model.ExecNewPodHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.FSGroupStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.FSGroupStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.FSGroupStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.FSGroupStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GenericWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GenericWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.GenericWebHookCause actual) {
    return new io.fabric8.openshift.api.model.GenericWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitBuildSourceAssert assertThat(io.fabric8.openshift.api.model.GitBuildSource actual) {
    return new io.fabric8.openshift.api.model.GitBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitHubWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitHubWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.GitHubWebHookCause actual) {
    return new io.fabric8.openshift.api.model.GitHubWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitLabWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitLabWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.GitLabWebHookCause actual) {
    return new io.fabric8.openshift.api.model.GitLabWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.GitSourceRevision actual) {
    return new io.fabric8.openshift.api.model.GitSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupAssert assertThat(io.fabric8.openshift.api.model.Group actual) {
    return new io.fabric8.openshift.api.model.GroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupListAssert assertThat(io.fabric8.openshift.api.model.GroupList actual) {
    return new io.fabric8.openshift.api.model.GroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupRestrictionAssert assertThat(io.fabric8.openshift.api.model.GroupRestriction actual) {
    return new io.fabric8.openshift.api.model.GroupRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IDRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IDRangeAssert assertThat(io.fabric8.openshift.api.model.IDRange actual) {
    return new io.fabric8.openshift.api.model.IDRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityAssert assertThat(io.fabric8.openshift.api.model.Identity actual) {
    return new io.fabric8.openshift.api.model.IdentityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityListAssert assertThat(io.fabric8.openshift.api.model.IdentityList actual) {
    return new io.fabric8.openshift.api.model.IdentityListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageAssert assertThat(io.fabric8.openshift.api.model.Image actual) {
    return new io.fabric8.openshift.api.model.ImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeCauseAssert assertThat(io.fabric8.openshift.api.model.ImageChangeCause actual) {
    return new io.fabric8.openshift.api.model.ImageChangeCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeTriggerAssert assertThat(io.fabric8.openshift.api.model.ImageChangeTrigger actual) {
    return new io.fabric8.openshift.api.model.ImageChangeTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageImportSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageImportSpecAssert assertThat(io.fabric8.openshift.api.model.ImageImportSpec actual) {
    return new io.fabric8.openshift.api.model.ImageImportSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageImportStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageImportStatusAssert assertThat(io.fabric8.openshift.api.model.ImageImportStatus actual) {
    return new io.fabric8.openshift.api.model.ImageImportStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageLabelAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageLabelAssert assertThat(io.fabric8.openshift.api.model.ImageLabel actual) {
    return new io.fabric8.openshift.api.model.ImageLabelAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageLayerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageLayerAssert assertThat(io.fabric8.openshift.api.model.ImageLayer actual) {
    return new io.fabric8.openshift.api.model.ImageLayerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageListAssert assertThat(io.fabric8.openshift.api.model.ImageList actual) {
    return new io.fabric8.openshift.api.model.ImageListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageLookupPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageLookupPolicyAssert assertThat(io.fabric8.openshift.api.model.ImageLookupPolicy actual) {
    return new io.fabric8.openshift.api.model.ImageLookupPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSignatureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSignatureAssert assertThat(io.fabric8.openshift.api.model.ImageSignature actual) {
    return new io.fabric8.openshift.api.model.ImageSignatureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSourceAssert assertThat(io.fabric8.openshift.api.model.ImageSource actual) {
    return new io.fabric8.openshift.api.model.ImageSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSourcePathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSourcePathAssert assertThat(io.fabric8.openshift.api.model.ImageSourcePath actual) {
    return new io.fabric8.openshift.api.model.ImageSourcePathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamAssert assertThat(io.fabric8.openshift.api.model.ImageStream actual) {
    return new io.fabric8.openshift.api.model.ImageStreamAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamImportAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamImportAssert assertThat(io.fabric8.openshift.api.model.ImageStreamImport actual) {
    return new io.fabric8.openshift.api.model.ImageStreamImportAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamImportSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamImportSpecAssert assertThat(io.fabric8.openshift.api.model.ImageStreamImportSpec actual) {
    return new io.fabric8.openshift.api.model.ImageStreamImportSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamImportStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamImportStatusAssert assertThat(io.fabric8.openshift.api.model.ImageStreamImportStatus actual) {
    return new io.fabric8.openshift.api.model.ImageStreamImportStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamListAssert assertThat(io.fabric8.openshift.api.model.ImageStreamList actual) {
    return new io.fabric8.openshift.api.model.ImageStreamListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamSpecAssert assertThat(io.fabric8.openshift.api.model.ImageStreamSpec actual) {
    return new io.fabric8.openshift.api.model.ImageStreamSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamStatusAssert assertThat(io.fabric8.openshift.api.model.ImageStreamStatus actual) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamTagAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamTagAssert assertThat(io.fabric8.openshift.api.model.ImageStreamTag actual) {
    return new io.fabric8.openshift.api.model.ImageStreamTagAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamTagListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamTagListAssert assertThat(io.fabric8.openshift.api.model.ImageStreamTagList actual) {
    return new io.fabric8.openshift.api.model.ImageStreamTagListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LifecycleHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LifecycleHookAssert assertThat(io.fabric8.openshift.api.model.LifecycleHook actual) {
    return new io.fabric8.openshift.api.model.LifecycleHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert assertThat(io.fabric8.openshift.api.model.LocalSubjectAccessReview actual) {
    return new io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagEventListAssert assertThat(io.fabric8.openshift.api.model.NamedTagEventList actual) {
    return new io.fabric8.openshift.api.model.NamedTagEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NetNamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NetNamespaceAssert assertThat(io.fabric8.openshift.api.model.NetNamespace actual) {
    return new io.fabric8.openshift.api.model.NetNamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NetNamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NetNamespaceListAssert assertThat(io.fabric8.openshift.api.model.NetNamespaceList actual) {
    return new io.fabric8.openshift.api.model.NetNamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAssert assertThat(io.fabric8.openshift.api.model.OAuthClient actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorization actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftClusterRoleAssert assertThat(io.fabric8.openshift.api.model.OpenshiftClusterRole actual) {
    return new io.fabric8.openshift.api.model.OpenshiftClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.OpenshiftClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.OpenshiftClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestrictionAssert assertThat(io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestriction actual) {
    return new io.fabric8.openshift.api.model.OpenshiftClusterRoleScopeRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRole actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleBindingAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRoleBinding actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRoleBindingRestriction actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpecAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpec actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleBindingRestrictionSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OpenshiftRoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OpenshiftRoleListAssert assertThat(io.fabric8.openshift.api.model.OpenshiftRoleList actual) {
    return new io.fabric8.openshift.api.model.OpenshiftRoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ParameterAssert assertThat(io.fabric8.openshift.api.model.Parameter actual) {
    return new io.fabric8.openshift.api.model.ParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyRuleAssert assertThat(io.fabric8.openshift.api.model.PolicyRule actual) {
    return new io.fabric8.openshift.api.model.PolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectAssert assertThat(io.fabric8.openshift.api.model.Project actual) {
    return new io.fabric8.openshift.api.model.ProjectAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectListAssert assertThat(io.fabric8.openshift.api.model.ProjectList actual) {
    return new io.fabric8.openshift.api.model.ProjectListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectRequestAssert assertThat(io.fabric8.openshift.api.model.ProjectRequest actual) {
    return new io.fabric8.openshift.api.model.ProjectRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectSpecAssert assertThat(io.fabric8.openshift.api.model.ProjectSpec actual) {
    return new io.fabric8.openshift.api.model.ProjectSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectStatusAssert assertThat(io.fabric8.openshift.api.model.ProjectStatus actual) {
    return new io.fabric8.openshift.api.model.ProjectStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RecreateDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RepositoryImportSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RepositoryImportSpecAssert assertThat(io.fabric8.openshift.api.model.RepositoryImportSpec actual) {
    return new io.fabric8.openshift.api.model.RepositoryImportSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RepositoryImportStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RepositoryImportStatusAssert assertThat(io.fabric8.openshift.api.model.RepositoryImportStatus actual) {
    return new io.fabric8.openshift.api.model.RepositoryImportStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteAssert assertThat(io.fabric8.openshift.api.model.Route actual) {
    return new io.fabric8.openshift.api.model.RouteAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteIngressAssert assertThat(io.fabric8.openshift.api.model.RouteIngress actual) {
    return new io.fabric8.openshift.api.model.RouteIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteIngressConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteIngressConditionAssert assertThat(io.fabric8.openshift.api.model.RouteIngressCondition actual) {
    return new io.fabric8.openshift.api.model.RouteIngressConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteListAssert assertThat(io.fabric8.openshift.api.model.RouteList actual) {
    return new io.fabric8.openshift.api.model.RouteListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoutePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoutePortAssert assertThat(io.fabric8.openshift.api.model.RoutePort actual) {
    return new io.fabric8.openshift.api.model.RoutePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteSpecAssert assertThat(io.fabric8.openshift.api.model.RouteSpec actual) {
    return new io.fabric8.openshift.api.model.RouteSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteStatusAssert assertThat(io.fabric8.openshift.api.model.RouteStatus actual) {
    return new io.fabric8.openshift.api.model.RouteStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteTargetReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteTargetReferenceAssert assertThat(io.fabric8.openshift.api.model.RouteTargetReference actual) {
    return new io.fabric8.openshift.api.model.RouteTargetReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RunAsUserStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.RunAsUserStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.RunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.SELinuxContextStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ScopeRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ScopeRestrictionAssert assertThat(io.fabric8.openshift.api.model.ScopeRestriction actual) {
    return new io.fabric8.openshift.api.model.ScopeRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecretBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecretBuildSourceAssert assertThat(io.fabric8.openshift.api.model.SecretBuildSource actual) {
    return new io.fabric8.openshift.api.model.SecretBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecretLocalReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecretLocalReferenceAssert assertThat(io.fabric8.openshift.api.model.SecretLocalReference actual) {
    return new io.fabric8.openshift.api.model.SecretLocalReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecretSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecretSpecAssert assertThat(io.fabric8.openshift.api.model.SecretSpec actual) {
    return new io.fabric8.openshift.api.model.SecretSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecurityContextConstraintsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecurityContextConstraintsAssert assertThat(io.fabric8.openshift.api.model.SecurityContextConstraints actual) {
    return new io.fabric8.openshift.api.model.SecurityContextConstraintsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecurityContextConstraintsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecurityContextConstraintsListAssert assertThat(io.fabric8.openshift.api.model.SecurityContextConstraintsList actual) {
    return new io.fabric8.openshift.api.model.SecurityContextConstraintsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ServiceAccountReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ServiceAccountReferenceAssert assertThat(io.fabric8.openshift.api.model.ServiceAccountReference actual) {
    return new io.fabric8.openshift.api.model.ServiceAccountReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ServiceAccountRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ServiceAccountRestrictionAssert assertThat(io.fabric8.openshift.api.model.ServiceAccountRestriction actual) {
    return new io.fabric8.openshift.api.model.ServiceAccountRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureConditionAssert assertThat(io.fabric8.openshift.api.model.SignatureCondition actual) {
    return new io.fabric8.openshift.api.model.SignatureConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureIssuerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureIssuerAssert assertThat(io.fabric8.openshift.api.model.SignatureIssuer actual) {
    return new io.fabric8.openshift.api.model.SignatureIssuerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureSubjectAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureSubjectAssert assertThat(io.fabric8.openshift.api.model.SignatureSubject actual) {
    return new io.fabric8.openshift.api.model.SignatureSubjectAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.SourceBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceControlUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceControlUserAssert assertThat(io.fabric8.openshift.api.model.SourceControlUser actual) {
    return new io.fabric8.openshift.api.model.SourceControlUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceRevisionAssert assertThat(io.fabric8.openshift.api.model.SourceRevision actual) {
    return new io.fabric8.openshift.api.model.SourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.SourceStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.SourceStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.StageInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.StageInfoAssert assertThat(io.fabric8.openshift.api.model.StageInfo actual) {
    return new io.fabric8.openshift.api.model.StageInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.StepInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.StepInfoAssert assertThat(io.fabric8.openshift.api.model.StepInfo actual) {
    return new io.fabric8.openshift.api.model.StepInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SubjectAccessReviewAssert assertThat(io.fabric8.openshift.api.model.SubjectAccessReview actual) {
    return new io.fabric8.openshift.api.model.SubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert assertThat(io.fabric8.openshift.api.model.SubjectAccessReviewResponse actual) {
    return new io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsAssert assertThat(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions actual) {
    return new io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TLSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TLSConfigAssert assertThat(io.fabric8.openshift.api.model.TLSConfig actual) {
    return new io.fabric8.openshift.api.model.TLSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventAssert assertThat(io.fabric8.openshift.api.model.TagEvent actual) {
    return new io.fabric8.openshift.api.model.TagEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventConditionAssert assertThat(io.fabric8.openshift.api.model.TagEventCondition actual) {
    return new io.fabric8.openshift.api.model.TagEventConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagImageHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagImageHookAssert assertThat(io.fabric8.openshift.api.model.TagImageHook actual) {
    return new io.fabric8.openshift.api.model.TagImageHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagImportPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagImportPolicyAssert assertThat(io.fabric8.openshift.api.model.TagImportPolicy actual) {
    return new io.fabric8.openshift.api.model.TagImportPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagReferenceAssert assertThat(io.fabric8.openshift.api.model.TagReference actual) {
    return new io.fabric8.openshift.api.model.TagReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagReferencePolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagReferencePolicyAssert assertThat(io.fabric8.openshift.api.model.TagReferencePolicy actual) {
    return new io.fabric8.openshift.api.model.TagReferencePolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateAssert assertThat(io.fabric8.openshift.api.model.Template actual) {
    return new io.fabric8.openshift.api.model.TemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateListAssert assertThat(io.fabric8.openshift.api.model.TemplateList actual) {
    return new io.fabric8.openshift.api.model.TemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserAssert assertThat(io.fabric8.openshift.api.model.User actual) {
    return new io.fabric8.openshift.api.model.UserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserListAssert assertThat(io.fabric8.openshift.api.model.UserList actual) {
    return new io.fabric8.openshift.api.model.UserListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserRestrictionAssert assertThat(io.fabric8.openshift.api.model.UserRestriction actual) {
    return new io.fabric8.openshift.api.model.UserRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.WebHookTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.WebHookTriggerAssert assertThat(io.fabric8.openshift.api.model.WebHookTrigger actual) {
    return new io.fabric8.openshift.api.model.WebHookTriggerAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
