package io.fabric8.kubernetes.api.model.version;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Info} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractInfoAssert<S extends AbstractInfoAssert<S, A>, A extends Info> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractInfoAssert}</code> to make assertions on actual Info.
   * @param actual the Info we want to make assertions on.
   */
  protected AbstractInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property buildDate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert buildDate()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getBuildDate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildDate"));
  }


  /**
   * Navigates to the property compiler so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert compiler()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCompiler()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "compiler"));
  }


  /**
   * Navigates to the property gitCommit so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gitCommit()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGitCommit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gitCommit"));
  }


  /**
   * Navigates to the property gitTreeState so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gitTreeState()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGitTreeState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gitTreeState"));
  }


  /**
   * Navigates to the property gitVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gitVersion()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGitVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gitVersion"));
  }


  /**
   * Navigates to the property goVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert goVersion()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGoVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "goVersion"));
  }


  /**
   * Navigates to the property major so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert major()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMajor()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "major"));
  }


  /**
   * Navigates to the property minor so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert minor()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMinor()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "minor"));
  }


  /**
   * Navigates to the property platform so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert platform()  {
    // check that actual Info we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPlatform()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "platform"));
  }


}
